/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.ext.webasic.impl.filter;

import java.util.List;
import net.jplugin.core.log.api.ILogService;
import net.jplugin.core.service.api.ServiceFactory;
import net.jplugin.ext.webasic.api.IInvocationFilter;
import net.jplugin.ext.webasic.api.InvocationContext;
import net.jplugin.ext.webasic.impl.filter.IMethodCallback;
import net.jplugin.ext.webasic.impl.filter.MethodIllegleAccessException;

public abstract class MethodFilterManager {
    protected List<IInvocationFilter> filters;

    public abstract void init();

    public boolean hasFilter() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public Object executeWithFilter(InvocationContext ctx, IMethodCallback r) throws Throwable {
        if (this.filters == null) {
            return r.run();
        }
        for (IInvocationFilter f : this.filters) {
            if (f.before(ctx)) continue;
            throw new MethodIllegleAccessException(ctx);
        }
        try {
            ctx.setResult(r.run());
        }
        catch (Throwable t) {
            ctx.setTh(t);
        }
        for (int i = this.filters.size() - 1; i >= 0; --i) {
            IInvocationFilter f;
            f = this.filters.get(i);
            try {
                f.after(ctx);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ServiceFactory.getService(ILogService.class).getLogger(MethodFilterManager.class.getName()).error((Object)"Error when do service after filter", e);
            }
        }
        if (ctx.getTh() == null) {
            return ctx.getResult();
        }
        throw ctx.getTh();
    }
}

