/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.ext.webasic.impl;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jplugin.core.config.api.RefConfig;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.PluginFilterManager;
import net.jplugin.core.kernel.api.RefAnnotationSupport;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContext;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.log.api.ILogService;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.service.api.ServiceFactory;
import net.jplugin.ext.webasic.api.HttpFilterContext;
import net.jplugin.ext.webasic.api.IControllerSet;
import net.jplugin.ext.webasic.api.WebContext;
import net.jplugin.ext.webasic.api.WebFilter;

public class WebDriver
extends RefAnnotationSupport {
    public static WebDriver INSTANCE = new WebDriver();
    public static final String SERVICE_CALL = "/service";
    private static Logger logger;
    IControllerSet[] controllerSets;
    ConcurrentHashMap<String, IControllerSet> pathMap = new ConcurrentHashMap();
    private WebFilter[] filters;
    private PluginFilterManager<HttpFilterContext> filterManager = new PluginFilterManager<HttpFilterContext>("EP_HTTP_FILTER", (fc, ctx) -> {
        this.doHttpAcure(ctx.getRequest(), ctx.getResponse());
        return null;
    });
    @RefConfig(path="platform.web-uri-parse-type", defaultValue="0")
    Integer webUriParseType;

    public void init() {
        this.filterManager.init();
        this.controllerSets = PluginEnvirement.getInstance().getExtensionObjects("EP_CONTROLLERSET", IControllerSet.class);
        this.filters = PluginEnvirement.getInstance().getExtensionObjects("EP_WEBFILTER", WebFilter.class);
        for (int i = 0; i < this.controllerSets.length; ++i) {
            this.controllerSets[i].init();
        }
        for (IControllerSet is : this.controllerSets) {
            Set<String> paths = is.getAcceptPaths();
            for (String p : paths) {
                if (this.pathMap.containsKey(p)) {
                    throw new RuntimeException("Multi web handlers can work with :" + p);
                }
                this.pathMap.put(p, is);
            }
        }
    }

    public IControllerSet[] getControllerSet() {
        return this.controllerSets;
    }

    public void dohttp(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ThreadLocalContext tlc = null;
        try {
            tlc = ThreadLocalContextManager.instance.createContext();
            this.filterManager.filter(HttpFilterContext.create(req, res));
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.getLogger().error((Object)("Error when service " + req.getRequestURI()), e);
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new ServletException(e);
        }
        finally {
            ThreadLocalContextManager.instance.releaseContext();
        }
    }

    private void doHttpAcure(HttpServletRequest req, HttpServletResponse res) throws Throwable {
        WebContext.initFromRequest(req);
        if (this.doWebFilter(req, res)) {
            Throwable th = null;
            try {
                String path = req.getServletPath();
                ControllerMeta controllerMeta = this.parseControllerMeta(path);
                if (controllerMeta == null) {
                    throw new RuntimeException("Can't find controller for :" + path);
                }
                controllerMeta.controllerSet.dohttp(controllerMeta.servicePath, req, res, controllerMeta.operation);
                this.doAfterWebFilter(req, res, null);
            }
            catch (Throwable t) {
                th = t;
                this.doAfterWebFilter(req, res, th);
            }
            if (th != null) {
                throw th;
            }
        }
    }

    private boolean doWebFilter(HttpServletRequest req, HttpServletResponse res) {
        for (WebFilter wf : this.filters) {
            if (wf.doFilter(req, res)) continue;
            return false;
        }
        return true;
    }

    private void doAfterWebFilter(HttpServletRequest req, HttpServletResponse res, Throwable th) {
        for (int i = this.filters.length - 1; i >= 0; --i) {
            WebFilter filter = this.filters[i];
            try {
                filter.doAfter(req, res, th);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ServiceFactory.getService(ILogService.class).getLogger(this.getClass().getName()).error((Object)req.getRequestURI(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Logger getLogger() {
        if (logger == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                ILogService log = ServiceFactory.getService(ILogService.class);
                logger = log.getLogger(this.getClass().getName());
            }
        }
        return logger;
    }

    public ControllerMeta parseControllerMeta(String path) {
        if (this.webUriParseType == 1) {
            return this.parseB2F(path);
        }
        return this.parseF2B(path);
    }

    private ControllerMeta parseF2B(String path) {
        int dotPos = path.lastIndexOf(46);
        if (dotPos >= 0) {
            path = path.substring(0, dotPos);
        }
        if (this.pathMap.get("/") != null) {
            return new ControllerMeta(this.pathMap.get("/"), "/", path.substring(1));
        }
        int pos = 1;
        while (true) {
            if ((pos = path.indexOf(47, pos)) < 0) {
                IControllerSet ctroller = this.pathMap.get(path);
                if (ctroller != null) {
                    return new ControllerMeta(ctroller, path, null);
                }
                return null;
            }
            String prePath = path.substring(0, pos);
            IControllerSet ctroller = this.pathMap.get(prePath);
            if (ctroller != null) {
                String postPath = path.substring(pos + 1);
                return new ControllerMeta(ctroller, prePath, postPath);
            }
            ++pos;
        }
    }

    private ControllerMeta parseB2F(String path) {
        IControllerSet ctroller;
        int dotPos = path.lastIndexOf(46);
        if (dotPos >= 0) {
            path = path.substring(0, dotPos);
        }
        if ((ctroller = this.pathMap.get(path)) != null) {
            return new ControllerMeta(ctroller, path, null);
        }
        int splitPos = path.lastIndexOf(47);
        if (splitPos > 0) {
            String prePath = path.substring(0, splitPos);
            String postPath = path.substring(splitPos + 1);
            ctroller = this.pathMap.get(prePath);
            if (ctroller != null) {
                return new ControllerMeta(ctroller, prePath, postPath);
            }
        }
        return null;
    }

    public static class ControllerMeta {
        IControllerSet controllerSet;
        String servicePath;
        String operation;

        ControllerMeta(IControllerSet cs, String s, String o) {
            this.controllerSet = cs;
            this.servicePath = s;
            this.operation = o;
        }

        public IControllerSet getControllerSet() {
            return this.controllerSet;
        }

        public String getServicePath() {
            return this.servicePath;
        }

        public String getOperation() {
            return this.operation;
        }
    }
}

