/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.ext.webasic.impl;

import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.ctx.RequesterInfo;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;

public class MtInvocationFilterHandler {
    public static final String TENANT_ID = "TenantId";
    public static MtInvocationFilterHandler instance;
    private ReqParamAt paraAt;
    private String reqParamName;
    private String reqDefaultTenant;
    private boolean enable = "true".equalsIgnoreCase(ConfigFactory.getStringConfigWithTrim("mtenant.enable"));

    public MtInvocationFilterHandler() {
        if (!this.enable) {
            return;
        }
        String reqParamAt = ConfigFactory.getStringConfigWithTrim("mtenant.req-param-at");
        this.reqParamName = ConfigFactory.getStringConfigWithTrim("mtenant.req-param-name");
        this.reqDefaultTenant = ConfigFactory.getStringConfigWithTrim("mtenant.req-default-tenant");
        if (StringKit.isNull(reqParamAt)) {
            throw new RuntimeException("config mtenant.req-param-at is  null");
        }
        if (StringKit.isNull(this.reqParamName)) {
            reqParamAt = "BOTH";
        }
        PluginEnvirement.INSTANCE.getStartLogger().log("@@@mtenant.req-param-at=" + reqParamAt);
        PluginEnvirement.INSTANCE.getStartLogger().log("@@@mtenant.req-param-name=" + this.reqParamName);
        PluginEnvirement.INSTANCE.getStartLogger().log("@@@mtenant.req-default-tenant=" + this.reqDefaultTenant);
        this.paraAt = ReqParamAt.valueOf(reqParamAt);
    }

    public void handle(RequesterInfo reqInfo) {
        if (!this.enable) {
            return;
        }
        String v1 = reqInfo.getHeaders().getHeader(TENANT_ID);
        if (v1 == null || "".equals(v1)) {
            if (this.paraAt == ReqParamAt.REQUEST) {
                v1 = reqInfo.getContent().getParamContent().get(this.reqParamName);
            } else if (this.paraAt == ReqParamAt.COOKIE) {
                v1 = reqInfo.getCookies().getCookie(this.reqParamName);
            } else if (this.paraAt == ReqParamAt.BOTH) {
                v1 = reqInfo.getContent().getParamContent().get(this.reqParamName);
                if (StringKit.isNull(v1)) {
                    v1 = reqInfo.getCookies().getCookie(this.reqParamName);
                }
            } else {
                throw new RuntimeException("Error ReqParamAt value:" + (Object)((Object)this.paraAt));
            }
        }
        this.checkAndSet(reqInfo, v1);
    }

    public void checkAndSet(RequesterInfo reqInfo, String v) {
        if (!this.enable) {
            return;
        }
        if (v != null && !"".equals(v)) {
            reqInfo.setCurrentTenantId(v);
            return;
        }
        if (StringKit.isNotNull(this.reqDefaultTenant)) {
            ThreadLocalContextManager.getCurrentContext().setAttribute("$using-def-tenant", true);
            reqInfo.setCurrentTenantId(this.reqDefaultTenant);
        }
    }

    public static void init() {
        instance = new MtInvocationFilterHandler();
    }

    static enum ReqParamAt {
        BOTH,
        COOKIE,
        REQUEST;

    }
}

