/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.ext.webasic.impl;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jplugin.common.kits.http.ContentKit;
import net.jplugin.core.kernel.api.ctx.Cookies;
import net.jplugin.core.kernel.api.ctx.Headers;
import net.jplugin.core.kernel.api.ctx.RequesterInfo;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContext;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.ext.webasic.api.WebFilter;
import net.jplugin.ext.webasic.impl.MtInvocationFilterHandler;
import net.jplugin.ext.webasic.kits.StreamContentKit;

public class InitRequestInfoFilterNew
implements WebFilter {
    private static final String _AID = "_aid";
    private static final String _OID = "_oid";
    private static final String _OTK = "_otk";
    private static final String _ATK = "_atk";
    private static final String HAID = "HAID";
    private static final String HOID = "HOID";
    private static final String HOTK = "HOTK";
    private static final String HATK = "HATK";
    public static final String _REQID = "ReqSerialKey";

    @Override
    public boolean doFilter(HttpServletRequest req, HttpServletResponse res) {
        ThreadLocalContext tlContext = ThreadLocalContextManager.instance.getContext();
        tlContext.setAttribute("$servlet-request", req);
        tlContext.setAttribute("$servlet-response", res);
        RequesterInfo requestInfo = tlContext.getRequesterInfo();
        this.parseContent(requestInfo, req);
        this.parseCookies(requestInfo, req);
        this.parseHeaders(requestInfo, req);
        requestInfo.setRequestUrl(req.getRequestURL().toString());
        requestInfo.setCallerIpAddress(this.getClientIp(req));
        InitRequestInfoFilterNew.fillFromBasicReqInfo(requestInfo);
        return true;
    }

    private void parseHeaders(RequesterInfo requestInfo, HttpServletRequest req) {
        requestInfo.getHeaders().setHeader(_REQID, req.getHeader(_REQID));
        requestInfo.getHeaders().setHeader("Referer", req.getHeader("Referer"));
        requestInfo.getHeaders().setHeader("TenantId", req.getHeader("TenantId"));
        requestInfo.getHeaders().setHeader(HAID, req.getHeader(HAID));
        requestInfo.getHeaders().setHeader(HOID, req.getHeader(HOID));
        requestInfo.getHeaders().setHeader(HOTK, req.getHeader(HOTK));
        requestInfo.getHeaders().setHeader(HATK, req.getHeader(HATK));
    }

    private void parseCookies(RequesterInfo requestInfo, HttpServletRequest req) {
        Cookie[] arr = req.getCookies();
        if (arr != null) {
            Cookies cookies = requestInfo.getCookies();
            for (Cookie c : arr) {
                cookies.setCookie(c.getName(), c.getValue());
            }
        }
    }

    public static void fillFromBasicReqInfo(RequesterInfo requestInfo) {
        RequesterInfo.Content content = requestInfo.getContent();
        Map<String, String> map = content.getParamContent();
        String clientAppToken = map.get(_ATK);
        String operatorToken = map.get(_OTK);
        if (clientAppToken != null || operatorToken != null) {
            requestInfo.setClientAppToken(clientAppToken);
            requestInfo.setOperatorToken(operatorToken);
            requestInfo.setOperatorId(map.get(_OID));
            requestInfo.setClientAppCode(map.get(_AID));
        } else {
            Headers headers = requestInfo.getHeaders();
            clientAppToken = headers.getHeader(HATK);
            operatorToken = headers.getHeader(HOTK);
            if (clientAppToken != null || operatorToken != null) {
                requestInfo.setClientAppToken(clientAppToken);
                requestInfo.setOperatorToken(operatorToken);
                requestInfo.setOperatorId(headers.getHeader(HOID));
                requestInfo.setClientAppCode(headers.getHeader(HAID));
            }
        }
        MtInvocationFilterHandler.instance.handle(requestInfo);
    }

    private String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip;
    }

    private void parseContent(RequesterInfo reqInfo, HttpServletRequest req) {
        RequesterInfo.Content content = reqInfo.getContent();
        String theContentType = req.getContentType();
        content.setContentType(theContentType);
        if (ContentKit.isApplicationJson(theContentType)) {
            String json = StreamContentKit.readReqStream(req);
            content.setJsonContent(json);
        } else {
            Enumeration nms = req.getParameterNames();
            HashMap<String, String> param = new HashMap<String, String>();
            while (nms.hasMoreElements()) {
                String name = (String)nms.nextElement();
                param.put(name, req.getParameter(name));
            }
            content.setParamContent(param);
        }
    }

    @Override
    public void doAfter(HttpServletRequest req, HttpServletResponse res, Throwable th) {
    }
}

