/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.ext.webasic.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.ctx.api.RuleProxyHelper;
import net.jplugin.core.kernel.api.ClassDefine;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.PluginFilterManager;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.rclient.api.RemoteExecuteException;
import net.jplugin.ext.webasic.api.IControllerSet;
import net.jplugin.ext.webasic.api.IDynamicService;
import net.jplugin.ext.webasic.api.InvocationContext;
import net.jplugin.ext.webasic.api.ObjectDefine;
import net.jplugin.ext.webasic.impl.ESFRPCContext;
import net.jplugin.ext.webasic.impl.ESFRestContext;
import net.jplugin.ext.webasic.impl.ESFRestContextHelper;
import net.jplugin.ext.webasic.impl.InitRequestInfoFilterNew;
import net.jplugin.ext.webasic.impl.WebDriver;
import net.jplugin.ext.webasic.impl.filter.IMethodCallback;
import net.jplugin.ext.webasic.impl.filter.service.ServiceFilterManager;
import net.jplugin.ext.webasic.impl.restm.RestMethodControllerSet4Invoker;
import net.jplugin.ext.webasic.impl.restm.invoker.CallParam;
import net.jplugin.ext.webasic.impl.restm.invoker.IServiceInvoker;
import net.jplugin.ext.webasic.impl.restm.invoker.ServiceInvokerSet;
import net.jplugin.ext.webasic.impl.rmethod.RmethodControllerSet4Invoker;

public class ESFHelper {
    private static int SERVICE_TIME_LIMIT = 6000;
    static PluginFilterManager<Tuple2<ESFRPCContext, InvocationContext>> rpcFilterManager;
    static PluginFilterManager<Tuple2<ESFRestContext, CallParam>> restFilterManager;

    public static void init() {
        rpcFilterManager.init();
        restFilterManager.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeWithRule(ESFRPCContext ctx, String servicePath, Object obj, Method method, Object[] args) throws Throwable {
        ESFHelper.checkTimeOut(ctx.getMsgReceiveTime());
        if (obj instanceof IDynamicService) {
            throw new RuntimeException("Dynamic implemented service, not support rpc invoke. " + servicePath);
        }
        try {
            ThreadLocalContextManager.instance.createContext();
            InvocationContext sfc = new InvocationContext(servicePath, obj, method, args);
            Object object = rpcFilterManager.filter(Tuple2.with(ctx, sfc));
            return object;
        }
        finally {
            ThreadLocalContextManager.instance.releaseContext();
        }
    }

    private static void checkTimeOut(long msgReceiveTime) {
        if (msgReceiveTime > 0L && System.currentTimeMillis() - msgReceiveTime > (long)SERVICE_TIME_LIMIT) {
            throw new RemoteExecuteException("1005", "\u6267\u884c\u8d85\u65f6. limit=" + SERVICE_TIME_LIMIT);
        }
    }

    public static void callRestfulService(ESFRestContext ctx, CallParam cp) throws Throwable {
        ESFHelper.checkTimeOut(ctx.getMsgReceiveTime());
        try {
            ThreadLocalContextManager.instance.createContext();
            restFilterManager.filter(Tuple2.with(ctx, cp));
        }
        finally {
            ThreadLocalContextManager.instance.releaseContext();
        }
    }

    public static Object getObject(String uri) {
        WebDriver.ControllerMeta cm = WebDriver.INSTANCE.parseControllerMeta(uri);
        IControllerSet cs = cm.getControllerSet();
        if (cs instanceof RestMethodControllerSet4Invoker || cs instanceof RmethodControllerSet4Invoker) {
            IServiceInvoker si = ServiceInvokerSet.instance.getServiceInvoker(cm.getServicePath());
            return si.getObjectCallHelper().getObject();
        }
        return null;
    }

    public static Map<String, Object> getObjectsMap() {
        Set<String> paths = ServiceInvokerSet.instance.getAcceptPaths();
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        for (String path : paths) {
            ret.put(path, ServiceInvokerSet.instance.getServiceInvoker(path).getObjectCallHelper().getObject());
        }
        return ret;
    }

    public static Map<String, Class> getWebControllerClasses() {
        Map<String, ObjectDefine> objects = PluginEnvirement.getInstance().getExtensionMap("EP_WEBCONTROLLER", ObjectDefine.class);
        Map<String, ClassDefine> clazzes = PluginEnvirement.getInstance().getExtensionMap("EP_WEBEXCONTROLLER", ClassDefine.class);
        HashMap<String, Class> ret = new HashMap<String, Class>();
        for (Map.Entry<String, ObjectDefine> entry : objects.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().getObjClass());
        }
        for (Map.Entry<String, Object> entry : clazzes.entrySet()) {
            ret.put(entry.getKey(), ((ClassDefine)entry.getValue()).getClazz());
        }
        return ret;
    }

    static {
        SERVICE_TIME_LIMIT = ConfigFactory.getIntConfig("platform.service-time-limit", 6000);
        PluginEnvirement.getInstance().getStartLogger().log("$$$ platform.service-time-limit is " + SERVICE_TIME_LIMIT);
        rpcFilterManager = new PluginFilterManager<Tuple2>("EP_ESF_RPC_FILTER", (fc, ctx) -> {
            ESFRPCContext.fill((ESFRPCContext)ctx.first);
            return ServiceFilterManager.INSTANCE.executeWithFilter((InvocationContext)ctx.second, new IMethodCallback((Tuple2)ctx){
                final /* synthetic */ Tuple2 val$ctx;
                {
                    this.val$ctx = tuple2;
                }

                @Override
                public Object run() throws Throwable {
                    return RuleProxyHelper.invokeWithRule(((InvocationContext)this.val$ctx.second).getObject(), ((InvocationContext)this.val$ctx.second).getMethod(), ((InvocationContext)this.val$ctx.second).getArgs());
                }
            });
        });
        restFilterManager = new PluginFilterManager<Tuple2>("EP_ESF_REST_FILTER", (fc, ctx) -> {
            ESFRestContextHelper.fillContentForRestful((CallParam)ctx.second, (ESFRestContext)ctx.first);
            InitRequestInfoFilterNew.fillFromBasicReqInfo(ThreadLocalContextManager.getRequestInfo());
            ServiceInvokerSet.instance.call((CallParam)ctx.second);
            return null;
        });
    }
}

