/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.ext.webasic.api;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jplugin.common.kits.MD5Kit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.ctx.api.JsonResult;
import net.jplugin.core.ctx.api.RuleResult;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.ext.webasic.kits.StreamContentKit;

public class AbstractExController {
    private static final String WA_CK = "wa_ck";
    private static final String WA_MD5 = "wa_md5";
    private static final String WA_CH = "wa_ch";
    public static final String JSP_BASE = "/WEB-INF/classes/";
    private static final String HTTP_REQ = "HTTP_REQ";
    private static final String HTTP_RES = "HTTP_RES";
    private static Boolean autoSetParamToReqAttr = null;

    public final void _init(HttpServletRequest req, HttpServletResponse res) {
        ThreadLocalContextManager.instance.getContext().setAttribute(HTTP_REQ, req);
        ThreadLocalContextManager.instance.getContext().setAttribute(HTTP_RES, res);
        if (autoSetParamToReqAttr.booleanValue()) {
            Enumeration nms = req.getParameterNames();
            while (nms.hasMoreElements()) {
                String name = (String)nms.nextElement();
                req.setAttribute(name, (Object)req.getParameter(name));
            }
        }
    }

    public HttpServletRequest getReq() {
        return (HttpServletRequest)ThreadLocalContextManager.instance.getContext().getAttribute(HTTP_REQ);
    }

    public HttpServletResponse getRes() {
        return (HttpServletResponse)ThreadLocalContextManager.instance.getContext().getAttribute(HTTP_RES);
    }

    public String getStreamJsonContent() {
        return StreamContentKit.getContent(this.getReq());
    }

    public String getParam(String nm) {
        return this.getReq().getParameter(nm);
    }

    public Object getAttr(String nm) {
        return this.getReq().getAttribute(nm);
    }

    public Set<String> getAttrNames() {
        HashSet<String> ret = new HashSet<String>();
        Enumeration nms = this.getReq().getAttributeNames();
        while (nms.hasMoreElements()) {
            String key = (String)nms.nextElement();
            ret.add(key);
        }
        return ret;
    }

    public String getStringAttr(String nm) {
        return (String)this.getReq().getAttribute(nm);
    }

    public void setAttr(String nm, Object o) {
        this.getReq().setAttribute(nm, o);
    }

    public void forward(String path) {
        try {
            HttpServletRequest req = this.getReq();
            req.getRequestDispatcher(path).forward((ServletRequest)req, (ServletResponse)this.getRes());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void renderJsp(String jsp) {
        if (jsp.startsWith("/")) {
            this.forward(jsp);
        } else {
            String jsppath;
            String name = this.getClass().getName();
            if (name.indexOf(46) > 0) {
                name = name.substring(0, name.lastIndexOf(46));
                name = StringKit.replaceStr(name, ".", "/");
                jsppath = JSP_BASE + name + "/" + jsp;
            } else {
                jsppath = JSP_BASE + jsp;
            }
            this.forward(jsppath);
        }
    }

    @Deprecated
    public void renderJson(String json) {
        this.getRes().setContentType("text/html; charset=utf-8");
        try {
            this.getRes().getWriter().print(json);
        }
        catch (IOException e) {
            throw new RuntimeException("render json error" + json, e);
        }
    }

    @Deprecated
    public void renderJson(JsonResult jr) {
        HttpServletRequest req = this.getReq();
        String wa_ck = (String)req.getAttribute(WA_CK);
        if ("true".equals(wa_ck)) {
            jr._setProp(WA_CH, "true");
            jr._setProp(WA_MD5, "%{MD5KEY}%");
            String jsonToWrite = jr.toJson();
            String oldMd5 = (String)req.getAttribute(WA_MD5);
            String newMd5 = MD5Kit.MD5(jsonToWrite);
            if (newMd5.equals(oldMd5)) {
                JsonResult newrr = JsonResult.create();
                newrr._setProp(WA_CH, "false");
                jsonToWrite = newrr.toJson();
            } else {
                jsonToWrite = StringKit.replaceStr(jsonToWrite, "%{MD5KEY}%", newMd5);
            }
            this.renderJson(jsonToWrite);
        } else {
            this.renderJson(jr.toJson());
        }
    }

    @Deprecated
    public void renderJson(RuleResult rr) {
        HttpServletRequest req = this.getReq();
        String wa_ck = (String)req.getAttribute(WA_CK);
        if ("true".equals(wa_ck)) {
            rr.setContent(WA_CH, "true");
            rr.setContent(WA_MD5, "%{MD5KEY}%");
            String jsonToWrite = rr.getJson();
            String oldMd5 = (String)req.getAttribute(WA_MD5);
            String newMd5 = MD5Kit.MD5(jsonToWrite);
            if (newMd5.equals(oldMd5)) {
                RuleResult newrr = RuleResult.create();
                newrr.setContent(WA_CH, "false");
                jsonToWrite = newrr.getJson();
            } else {
                jsonToWrite = StringKit.replaceStr(jsonToWrite, "%{MD5KEY}%", newMd5);
            }
            this.renderJson(jsonToWrite);
        } else {
            this.renderJson(rr.getJson());
        }
    }

    public void invalidSession() {
        HttpServletRequest req = this.getReq();
        req.getSession().invalidate();
    }

    public void setSessAttr(String k, Object v) {
        HttpServletRequest req = this.getReq();
        req.getSession().setAttribute(k, v);
    }

    public void sendRedirect(String path) {
        HttpServletResponse res = this.getRes();
        try {
            res.sendRedirect(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        autoSetParamToReqAttr = !"false".equalsIgnoreCase(ConfigFactory.getStringConfigWithTrim("platform.abs-exctl-auto-set-param-to-reqattr"));
        PluginEnvirement.getInstance().getStartLogger().log("autoSetParamToReqAttr=" + autoSetParamToReqAttr);
    }
}

