/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.ext.staticweb.impl;

import java.util.HashMap;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.FileKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.ext.staticweb.api.IContentManager;
import net.jplugin.ext.staticweb.impl.ContentTypeMaps;

public class ConentManagerImpl
implements IContentManager {
    private static final int MAX_POST_CHECK = 15;

    @Override
    public boolean accept(String uri) {
        String post = this.getPost(uri);
        return post != null && !".do".equals(post);
    }

    private String getContentTypeForUri(String uri) {
        String post = this.getPost(uri);
        return ContentTypeMaps.get(post);
    }

    private String getPost(String uri) {
        int maxlen = 15;
        int lastIndex = uri.lastIndexOf(46);
        if (lastIndex < 0) {
            return null;
        }
        if (uri.length() - lastIndex > maxlen) {
            return null;
        }
        String post = uri.substring(lastIndex);
        return post;
    }

    public String getContentTypeForPostPrefix(String post) {
        return ContentTypeMaps.get(post);
    }

    @Override
    public IContentManager.Response handleRequest(IContentManager.Request req) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String uri = req.getUri();
        String contentType = this.getContentTypeForUri(uri);
        if (contentType == null) {
            contentType = "text/html";
        }
        if ("text/html".equals(contentType)) {
            contentType = "text/html; charset=utf-8";
        }
        headers.put("ContentType", contentType);
        byte[] content = this.loadContent(req);
        IContentManager.Response response = IContentManager.Response.create(headers, content);
        return response;
    }

    private byte[] loadContent(IContentManager.Request req) {
        String uri = req.getUri();
        if (!ConentManagerImpl.checkPath(uri)) {
            return ("Illegal path,file=" + uri).getBytes();
        }
        String path = PluginEnvirement.INSTANCE.getWebRootPath() + uri;
        if (FileKit.existsAndIsFile(path)) {
            byte[] content = FileKit.file2Bytes(path);
            return content;
        }
        return ("File not found,file=" + uri).getBytes();
    }

    private static boolean checkPath(String uri) {
        if (StringKit.isNull(uri)) {
            return true;
        }
        if (!uri.startsWith("/") && !uri.startsWith("\\")) {
            return false;
        }
        String temp = StringKit.replaceStr(uri, "\\", "/");
        if (temp.equals("/")) {
            return true;
        }
        String[] arr = StringKit.splitStr(temp, "/");
        int v = 0;
        for (String a : arr) {
            if (StringKit.isNull(a) || ".".equals(a = a.trim())) continue;
            v = "..".equals(a) ? --v : ++v;
            if (v >= 0) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        AssertKit.assertEqual(ConentManagerImpl.checkPath(null), true);
        AssertKit.assertEqual(ConentManagerImpl.checkPath(""), true);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/"), true);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("\\"), true);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/a"), true);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/././a"), true);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/././."), true);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("a"), false);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/../a"), false);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/../."), false);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/a/.."), true);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/a/../.."), false);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/a/b/../../."), true);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/a/b/../../a/.././.."), false);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/a/b/../../a/.././.."), false);
        AssertKit.assertEqual(ConentManagerImpl.checkPath("/a/b/../ ../a/.././.."), false);
    }

    public static void main2(String[] args) {
        ConentManagerImpl o = new ConentManagerImpl();
        IContentManager.Response res = o.handleRequest(IContentManager.Request.create("/src/net/jplugin/ext/staticweb/Plugin.java"));
        System.out.println(new String(res.getContentBytes()));
        System.out.println("headers = " + res.getHeaders());
        res = o.handleRequest(IContentManager.Request.create("/src/net/jplugin/ext/staticweb/Plugin22.aa"));
        System.out.println(new String(res.getContentBytes()));
        System.out.println("headers = " + res.getHeaders());
    }
}

