/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.ext.gtrace.api;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContext;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.ext.gtrace.api.Span;

public class SpanStack {
    List<Span> list = new ArrayList<Span>(5);
    private static final String TRACE_CHILD_SPAN_INDEX = "TRACE_CHILD_SPAN_INDEX";

    public Span getCurrent() {
        int s = this.list.size();
        if (s < 1) {
            return this.pushSpan(9);
        }
        return this.list.get(s - 1);
    }

    public Span pushSpan(int spanType) {
        int index;
        String pid;
        if (this.list.isEmpty()) {
            ThreadLocalContext ctx = ThreadLocalContextManager.instance.getContext();
            pid = ctx.getRequesterInfo().getParSpanId();
            index = this.addChildIndex(ctx);
        } else {
            Span parentSpan = this.list.get(this.list.size() - 1);
            pid = parentSpan.getId();
            index = this.addChildIndex(parentSpan);
        }
        Span span = new Span(spanType, index, pid);
        this.list.add(span);
        return span;
    }

    private int addChildIndex(Span parentSpan) {
        int idx = parentSpan.getLastChildIndex();
        parentSpan.setLastChildIndex(++idx);
        return idx;
    }

    private int addChildIndex(ThreadLocalContext ctx) {
        Integer childSpanIndex = (Integer)ctx.getAttribute(TRACE_CHILD_SPAN_INDEX);
        if (childSpanIndex == null) {
            childSpanIndex = 0;
        }
        Integer n = childSpanIndex;
        Integer n2 = childSpanIndex = Integer.valueOf(childSpanIndex + 1);
        ctx.setAttribute(TRACE_CHILD_SPAN_INDEX, childSpanIndex);
        return childSpanIndex;
    }

    public void popSpan() {
        if (this.list.isEmpty()) {
            throw new RuntimeException("No span.");
        }
        this.list.remove(this.list.size() - 1);
    }
}

