/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.service;

import java.lang.annotation.Annotation;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.AbstractPlugin;
import net.jplugin.core.kernel.api.Beans;
import net.jplugin.core.kernel.api.Extension;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.service.api.BindService;
import net.jplugin.core.service.api.BindServiceSet;

public class ExtensionServiceHelper {
    public static void addServiceExtension(AbstractPlugin plugin, String name, Class impl) {
        plugin.addExtension(Extension.create("service", name, impl));
    }

    public static void autoBindServiceExtension(AbstractPlugin p, String pkgPath) {
        for (Class c : p.filterContainedClasses(pkgPath, BindService.class)) {
            BindService anno = c.getAnnotation(BindService.class);
            ExtensionServiceHelper.handleOneBind(p, c, anno);
        }
        for (Class c : p.filterContainedClasses(pkgPath, BindServiceSet.class)) {
            Annotation[] annos;
            for (Annotation a : annos = c.getAnnotationsByType(BindService.class)) {
                ExtensionServiceHelper.handleOneBind(p, c, a);
            }
        }
    }

    private static void handleOneBind(AbstractPlugin p, Class c, Annotation a) {
        BindService anno = (BindService)a;
        Class interfaceClazz = anno.interfaceClass();
        if (interfaceClazz.getName().equals(BindService.DefaultInterface.class.getName())) {
            interfaceClazz = ExtensionServiceHelper.computeInterfaceCls(c);
        }
        if (StringKit.isNull(anno.name())) {
            ExtensionServiceHelper.addServiceExtension(p, interfaceClazz.getName(), c);
            PluginEnvirement.INSTANCE.getStartLogger().log("$$$ Auto add extension for service: interface=" + interfaceClazz.getName() + " impl=" + c.getName());
        } else {
            ExtensionServiceHelper.addServiceExtension(p, anno.name(), c);
            PluginEnvirement.INSTANCE.getStartLogger().log("$$$ Auto add extension for service: interface=" + interfaceClazz.getName() + " impl=" + c.getName());
        }
        if (StringKit.isNotNull(anno.id())) {
            Beans.setLastId(anno.id());
        }
    }

    private static Class computeInterfaceCls(Class impClazz) {
        Class<?>[] clazzs = impClazz.getInterfaces();
        if (clazzs.length == 0) {
            throw new RuntimeException("Class must implement a interface, so as to be defined as a Service impl. " + impClazz.getName());
        }
        if (clazzs.length > 1) {
            throw new RuntimeException("Class with multiple interfaces, must specify one interface in annotation. " + impClazz.getName());
        }
        return clazzs[0];
    }
}

