/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.rclient.handler;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.jplugin.common.kits.JsonKit;
import net.jplugin.common.kits.SerializKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.http.HttpKit;
import net.jplugin.core.rclient.api.Client;
import net.jplugin.core.rclient.api.ClientInfo;
import net.jplugin.core.rclient.api.IClientHandler;
import net.jplugin.core.rclient.api.RemoteExecuteException;
import net.jplugin.core.rclient.handler.ServiceUrlResolverManager;
import net.jplugin.core.rclient.proxyfac.TokenFactory;

public class JavaRemotHandler
implements IClientHandler {
    static final String PARATYPES = "TYPES";
    static final String PARAVALUES = "PARA";
    static final String REMOTE_EXCEPTION_PREFIX = "$RE#";
    static final String OPERATION_KEY = "_o";

    @Override
    public Object invoke(Client c, Object proxy, Method method, Object[] args) throws Throwable {
        String realUrl;
        String ret;
        if (c.getServiceBaseUrl() == null) {
            throw new RuntimeException("Server url is null");
        }
        ClientInfo clientInfo = c.getClientInfo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(PARATYPES, SerializKit.encodeToString(method.getParameterTypes()));
        map.put(PARAVALUES, SerializKit.encodeToString(args));
        map.put(OPERATION_KEY, method.getName());
        if (clientInfo != null) {
            Map<String, String> extPara;
            String token;
            if (StringKit.isNotNull(clientInfo.getAppId())) {
                map.put("_aid", clientInfo.getAppId());
            }
            if (StringKit.isNotNull(token = TokenFactory.getAppToken())) {
                map.put("_atk", token);
            }
            if ((extPara = clientInfo.getExtParas()) != null) {
                for (Map.Entry<String, String> en : extPara.entrySet()) {
                    map.put(en.getKey(), en.getValue());
                }
            }
        }
        if (StringKit.isNull(ret = HttpKit.post((realUrl = ServiceUrlResolverManager.instance.resolveUrl(c.getProtocal(), c.getServiceBaseUrl())) + "/" + method.getName() + ".do", map))) {
            throw new RuntimeException("Server return null,perhaps can't find the controller or method not found");
        }
        Object retObj = SerializKit.deserialFromString(ret);
        if (retObj != null && retObj instanceof String && ((String)retObj).startsWith(REMOTE_EXCEPTION_PREFIX)) {
            String stemp = (String)retObj;
            stemp = stemp.substring(REMOTE_EXCEPTION_PREFIX.length());
            Map exInfo = JsonKit.json2Map(stemp);
            throw new RemoteExecuteException((String)exInfo.get("code"), (String)exInfo.get("msg"));
        }
        return retObj;
    }
}

