/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.mtenant.handler2;

import java.sql.Connection;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.das.api.sqlrefactor.ISqlRefactor;
import net.jplugin.core.das.dds.impl.DummyConnection;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.log.api.LogFactory;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.mtenant.api.ITenantStoreStrategyProvidor;
import net.jplugin.core.mtenant.handler2.SqlHandlerVisitorForMixed;
import net.jplugin.core.mtenant.handler2.TenantStoreStrategyManager;
import net.sf.jsqlparser.JSQLParserException;

public class SqlMultiTenantHanlderMixedImpl
implements ISqlRefactor {
    private static Logger logger = LogFactory.getLogger(SqlMultiTenantHanlderMixedImpl.class);
    private boolean allDataSource;
    private String[] dataSources = null;
    boolean init;
    boolean firstTimeMatchRouteConnection = true;

    public void init() {
        if (!this.init) {
            this.init = true;
            String datasource = ConfigFactory.getStringConfig("mtenant.datasource", "ALL");
            if ("ALL".equals(datasource)) {
                this.allDataSource = true;
            } else {
                this.allDataSource = false;
                this.dataSources = StringKit.splitStr(datasource, ",");
            }
        }
    }

    @Override
    public String refactSql(String dataSourceName, String sql, Connection conn) {
        this.init();
        String result = this.handleInner(dataSourceName, sql, conn);
        if (logger.isDebugEnabled() && !sql.equals(result)) {
            logger.debug("BeforeSQL = " + sql);
            logger.debug("After SQL = " + result);
        }
        return result;
    }

    public String handleInner(String dataSourceName, String sql, Connection conn) {
        if (!this.allDataSource && !this.inDataSourceList(dataSourceName)) {
            return sql;
        }
        boolean isRouter = false;
        try {
            isRouter = conn.isWrapperFor(DummyConnection.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while call isWrapper", e);
        }
        if (isRouter) {
            this.handleRouterConnectionConfigured(dataSourceName);
            return sql;
        }
        String tid = ThreadLocalContextManager.getRequestInfo().getCurrentTenantId();
        String schemaPrefix = ConfigFactory.getStringConfig("mtenant.schema-prefix." + dataSourceName);
        if (StringKit.isNull(schemaPrefix)) {
            throw new RuntimeException("The multi tenant datasource [" + dataSourceName + "] must be configed with a [schema-prefix." + dataSourceName + "] key");
        }
        if (StringKit.isNull(tid)) {
            throw new RuntimeException("The multi tenant datasource [" + dataSourceName + "] must be called with a tenantid request attribute");
        }
        return SqlMultiTenantHanlderMixedImpl.handle(sql, dataSourceName, schemaPrefix, tid);
    }

    private void handleRouterConnectionConfigured(String dataSourceName) {
        if (this.firstTimeMatchRouteConnection) {
            this.firstTimeMatchRouteConnection = false;
            PluginEnvirement.getInstance().getStartLogger().log("$$$ Router connection is configured for mtenant, noticed. " + dataSourceName);
        }
    }

    private boolean inDataSourceList(String dataSourceName) {
        for (String s : this.dataSources) {
            if (!s.equals(dataSourceName)) continue;
            return true;
        }
        return false;
    }

    private static String handle(String sql, String dataSourceName, String schemaPrefix, String tid) {
        ITenantStoreStrategyProvidor.Strategy stg = SqlMultiTenantHanlderMixedImpl.getStrategy(sql, dataSourceName);
        String finalSchema = SqlMultiTenantHanlderMixedImpl.makeFinalSchema(schemaPrefix, stg.getSchemaPostfix());
        SqlHandlerVisitorForMixed v = stg.getMode() == ITenantStoreStrategyProvidor.Mode.SHARE ? new SqlHandlerVisitorForMixed(finalSchema, tid) : new SqlHandlerVisitorForMixed(finalSchema);
        try {
            return v.handle(sql);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException("SQL gremma error." + e.getMessage() + "  " + sql, e);
        }
    }

    private static String makeFinalSchema(String schemaPrefix, String schemaPostfix) {
        if ("$NPR$".equals(schemaPostfix)) {
            return schemaPrefix;
        }
        return schemaPrefix + "_" + schemaPostfix;
    }

    private static ITenantStoreStrategyProvidor.Strategy getStrategy(String sql, String dataSource) {
        String tid = ThreadLocalContextManager.getRequestInfo().getCurrentTenantId();
        if (StringKit.isNull(tid)) {
            throw new RuntimeException("Can't find tenantid when handle sql");
        }
        ITenantStoreStrategyProvidor.Strategy stragegy = null;
        if (TenantStoreStrategyManager.instance.isProviderExist()) {
            stragegy = TenantStoreStrategyManager.instance.getStragegy(tid, dataSource);
            if (stragegy == null) {
                throw new RuntimeException("Can't get tenant store stragegy for tenent:" + tid);
            }
        } else {
            stragegy = SqlMultiTenantHanlderMixedImpl.getDefaultStrategy(sql, dataSource, tid);
        }
        return stragegy;
    }

    private static ITenantStoreStrategyProvidor.Strategy getDefaultStrategy(String sql, String dataSource, String tid) {
        ITenantStoreStrategyProvidor.Strategy s = new ITenantStoreStrategyProvidor.Strategy();
        s.setMode(ITenantStoreStrategyProvidor.Mode.ONESELF);
        s.setSchemaPostfix(tid);
        return s;
    }
}

