/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.mtenant.handler2;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.CollateExpression;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.NextValExpression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.ValueListExpression;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Block;
import net.sf.jsqlparser.statement.Commit;
import net.sf.jsqlparser.statement.DescribeStatement;
import net.sf.jsqlparser.statement.ExplainStatement;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.statement.ShowColumnsStatement;
import net.sf.jsqlparser.statement.ShowStatement;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.UseStatement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.comment.Comment;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.AlterView;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.execute.Execute;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.statement.values.ValuesStatement;

public class SqlHandlerVisitorForMixed
implements StatementVisitor,
SelectVisitor,
FromItemVisitor,
ExpressionVisitor,
ItemsListVisitor,
SelectItemVisitor {
    static String tenantColumnName;
    SqlRefactor sqlRefactor;
    String schemaName;
    String tenantId;

    public static void init() {
        tenantColumnName = ConfigFactory.getStringConfigWithTrim("mtenant.field");
        if (StringKit.isNull(tenantColumnName)) {
            tenantColumnName = "mtenant_id";
        }
        PluginEnvirement.getInstance().getStartLogger().log("**mtenant.field=" + tenantColumnName);
    }

    public SqlHandlerVisitorForMixed(String aSchemaName) {
        this(aSchemaName, null);
    }

    public SqlHandlerVisitorForMixed(String aSchemaName, String tid) {
        this.schemaName = aSchemaName;
        this.tenantId = tid;
        this.sqlRefactor = new SqlRefactor();
    }

    public String handle(String sql) throws JSQLParserException {
        if (sql.indexOf(59) < 0) {
            return this.handleOne(sql);
        }
        String[] arr = StringKit.splitStr(sql, ";");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                sb.append(";");
            }
            sb.append(this.handleOne(arr[i]));
        }
        return sb.toString();
    }

    private String handleOne(String sql) throws JSQLParserException {
        CCJSqlParserManager pm = new CCJSqlParserManager();
        Statement statement = pm.parse((Reader)new StringReader(sql));
        if (statement instanceof Select) {
            this.visit((Select)statement);
        } else if (statement instanceof Insert) {
            this.visit((Insert)statement);
        } else if (statement instanceof Update) {
            this.visit((Update)statement);
        } else if (statement instanceof Delete) {
            this.visit((Delete)statement);
        } else if (statement instanceof Replace) {
            this.visit((Replace)statement);
        } else if (statement instanceof CreateTable) {
            this.visit((CreateTable)statement);
        }
        return statement.toString();
    }

    public void visit(Select select) {
        select.getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(Delete delete) {
        this.sqlRefactor.handleDelete(delete);
        if (delete.getWhere() != null) {
            delete.getWhere().accept((ExpressionVisitor)this);
        }
    }

    public void visit(Update update) {
        this.sqlRefactor.handleUpdate(update);
        List exp = update.getExpressions();
        if (exp != null) {
            for (Expression e : exp) {
                e.accept((ExpressionVisitor)this);
            }
        }
        if (update.getWhere() != null) {
            update.getWhere().accept((ExpressionVisitor)this);
        }
    }

    public void visit(Insert insert) {
        ItemsList itemlist;
        this.sqlRefactor.handleInsert(this, insert);
        if (insert.getSelect() != null) {
            insert.getSelect().accept((StatementVisitor)this);
        }
        if ((itemlist = insert.getItemsList()) instanceof SubSelect) {
            ((SubSelect)itemlist).getSelectBody().accept((SelectVisitor)this);
        }
    }

    public void visit(Replace replace) {
        this.sqlRefactor.handleReplace(this, replace);
        ItemsList itemlist = replace.getItemsList();
        if (itemlist instanceof SubSelect) {
            ((SubSelect)itemlist).getSelectBody().accept((SelectVisitor)this);
        }
    }

    public void visit(Drop drop) {
        this.sqlRefactor.handleDrop(this, drop);
    }

    public void visit(Truncate truncate) {
        this.sqlRefactor.handleTruncate(this, truncate);
    }

    public void visit(CreateTable createTable) {
        this.sqlRefactor.handleCreateTable(this, createTable);
    }

    public void visit(PlainSelect plainSelect) {
        this.sqlRefactor.handleSelect(plainSelect);
        if (plainSelect.getSelectItems() != null) {
            for (SelectItem item : plainSelect.getSelectItems()) {
                item.accept((SelectItemVisitor)this);
            }
        }
        if (plainSelect.getFromItem() != null) {
            plainSelect.getFromItem().accept((FromItemVisitor)this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                join.getRightItem().accept((FromItemVisitor)this);
            }
        }
        if (plainSelect.getWhere() != null) {
            plainSelect.getWhere().accept((ExpressionVisitor)this);
        }
    }

    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(Addition addition) {
        this.visitBinaryExpression((BinaryExpression)addition);
    }

    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression((BinaryExpression)andExpression);
    }

    public void visit(Between between) {
        between.getLeftExpression().accept((ExpressionVisitor)this);
        between.getBetweenExpressionStart().accept((ExpressionVisitor)this);
        between.getBetweenExpressionEnd().accept((ExpressionVisitor)this);
    }

    public void visit(Division division) {
        this.visitBinaryExpression((BinaryExpression)division);
    }

    public void visit(EqualsTo equalsTo) {
        this.visitBinaryExpression((BinaryExpression)equalsTo);
    }

    public void visit(Function function) {
        if (function.getKeep() != null) {
            function.getKeep().accept((ExpressionVisitor)this);
        }
        if (function.getParameters() != null) {
            function.getParameters().accept((ItemsListVisitor)this);
        }
    }

    public void visit(GreaterThan greaterThan) {
        this.visitBinaryExpression((BinaryExpression)greaterThan);
    }

    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitBinaryExpression((BinaryExpression)greaterThanEquals);
    }

    public void visit(InExpression inExpression) {
        inExpression.getLeftExpression().accept((ExpressionVisitor)this);
        inExpression.getRightItemsList().accept((ItemsListVisitor)this);
    }

    public void visit(LikeExpression likeExpression) {
        this.visitBinaryExpression((BinaryExpression)likeExpression);
    }

    public void visit(ExistsExpression existsExpression) {
        existsExpression.getRightExpression().accept((ExpressionVisitor)this);
    }

    public void visit(MinorThan minorThan) {
        this.visitBinaryExpression((BinaryExpression)minorThan);
    }

    public void visit(MinorThanEquals minorThanEquals) {
        this.visitBinaryExpression((BinaryExpression)minorThanEquals);
    }

    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression((BinaryExpression)multiplication);
    }

    public void visit(NotEqualsTo notEqualsTo) {
        this.visitBinaryExpression((BinaryExpression)notEqualsTo);
    }

    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression((BinaryExpression)orExpression);
    }

    public void visit(Parenthesis parenthesis) {
        parenthesis.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression((BinaryExpression)subtraction);
    }

    public void visit(ExpressionList expressionList) {
        for (Expression expression : expressionList.getExpressions()) {
            expression.accept((ExpressionVisitor)this);
        }
    }

    public void visit(CaseExpression caseExpression) {
        List list;
        Expression se = caseExpression.getSwitchExpression();
        Expression ee = caseExpression.getElseExpression();
        if (se != null) {
            se.accept((ExpressionVisitor)this);
        }
        if (ee != null) {
            ee.accept((ExpressionVisitor)this);
        }
        if ((list = caseExpression.getWhenClauses()) != null) {
            for (Object o : list) {
                ((WhenClause)o).accept((ExpressionVisitor)this);
            }
        }
    }

    public void visit(WhenClause whenClause) {
        Expression te;
        Expression we = whenClause.getWhenExpression();
        if (we != null) {
            we.accept((ExpressionVisitor)this);
        }
        if ((te = whenClause.getThenExpression()) != null) {
            te.accept((ExpressionVisitor)this);
        }
    }

    public void visit(AllComparisonExpression allComparisonExpression) {
        allComparisonExpression.getSubSelect().getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(AnyComparisonExpression anyComparisonExpression) {
        anyComparisonExpression.getSubSelect().getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(SubJoin subjoin) {
        subjoin.getLeft().accept((FromItemVisitor)this);
        List joinlist = subjoin.getJoinList();
        if (joinlist != null) {
            for (Join join : joinlist) {
                join.getRightItem().accept((FromItemVisitor)this);
            }
        }
    }

    public void visit(Concat concat) {
        this.visitBinaryExpression((BinaryExpression)concat);
    }

    public void visit(Matches matches) {
        this.visitBinaryExpression((BinaryExpression)matches);
    }

    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression((BinaryExpression)bitwiseAnd);
    }

    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression((BinaryExpression)bitwiseOr);
    }

    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression((BinaryExpression)bitwiseXor);
    }

    private void visitBinaryExpression(BinaryExpression binaryExpression) {
        binaryExpression.getLeftExpression().accept((ExpressionVisitor)this);
        binaryExpression.getRightExpression().accept((ExpressionVisitor)this);
    }

    public void visit(LateralSubSelect ss) {
        ss.getSubSelect().getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(MultiExpressionList o) {
        List list = o.getExprList();
        if (list != null) {
            for (ExpressionList el : list) {
                el.accept((ItemsListVisitor)this);
            }
        }
    }

    public void visit(SelectExpressionItem selectExpressionItem) {
        Expression e = selectExpressionItem.getExpression();
        if (e != null) {
            e.accept((ExpressionVisitor)this);
        }
    }

    public void visit(AllColumns allColumns) {
    }

    public void visit(AllTableColumns allTableColumns) {
    }

    public void visit(LongValue longValue) {
    }

    public void visit(Column tableColumn) {
    }

    public void visit(DoubleValue doubleValue) {
    }

    public void visit(NullValue nullValue) {
    }

    public void visit(StringValue stringValue) {
    }

    public void visit(DateValue dateValue) {
    }

    public void visit(TimestampValue timestampValue) {
    }

    public void visit(TimeValue timeValue) {
    }

    public void visit(IsNullExpression isNullExpression) {
    }

    public void visit(JdbcParameter jdbcParameter) {
    }

    public void visit(SignedExpression se) {
        se.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(JdbcNamedParameter arg0) {
    }

    public void visit(HexValue arg0) {
    }

    public void visit(CastExpression arg0) {
    }

    public void visit(Modulo arg0) {
    }

    public void visit(AnalyticExpression arg0) {
    }

    public void visit(ExtractExpression ee) {
        ee.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(IntervalExpression ie) {
    }

    public void visit(OracleHierarchicalExpression arg0) {
    }

    public void visit(RegExpMatchOperator arg0) {
    }

    public void visit(JsonExpression arg0) {
    }

    public void visit(JsonOperator arg0) {
    }

    public void visit(RegExpMySQLOperator arg0) {
    }

    public void visit(UserVariable arg0) {
    }

    public void visit(NumericBind arg0) {
    }

    public void visit(KeepExpression arg0) {
    }

    public void visit(MySQLGroupConcat arg0) {
    }

    public void visit(RowConstructor arg0) {
    }

    public void visit(OracleHint arg0) {
    }

    public void visit(TimeKeyExpression arg0) {
    }

    public void visit(DateTimeLiteralExpression arg0) {
    }

    public void visit(NotExpression arg0) {
    }

    public void visit(ValuesList arg0) {
    }

    public void visit(TableFunction arg0) {
    }

    public void visit(NamedExpressionList namedExpressionList) {
    }

    public void visit(BitwiseRightShift aThis) {
    }

    public void visit(BitwiseLeftShift aThis) {
    }

    public void visit(ValueListExpression valueList) {
    }

    public void visit(NextValExpression aThis) {
    }

    public void visit(CollateExpression aThis) {
    }

    public void visit(SimilarToExpression aThis) {
    }

    public void visit(ParenthesisFromItem aThis) {
    }

    public void visit(Comment comment) {
    }

    public void visit(ShowColumnsStatement set) {
    }

    public void visit(UseStatement use) {
    }

    public void visit(Block block) {
    }

    public void visit(ValuesStatement values) {
    }

    public void visit(DescribeStatement describe) {
    }

    public void visit(ExplainStatement aThis) {
    }

    public void visit(ShowStatement aThis) {
    }

    public void visit(SetOperationList sol) {
        List selects = sol.getSelects();
        if (selects != null) {
            for (SelectBody s : selects) {
                s.accept((SelectVisitor)this);
            }
        }
    }

    public void visit(WithItem arg0) {
    }

    public void visit(Commit arg0) {
    }

    public void visit(CreateIndex arg0) {
    }

    public void visit(CreateView arg0) {
    }

    public void visit(AlterView arg0) {
    }

    public void visit(Alter arg0) {
    }

    public void visit(Statements arg0) {
    }

    public void visit(Execute arg0) {
    }

    public void visit(SetStatement arg0) {
    }

    public void visit(Merge arg0) {
    }

    public void visit(Upsert arg0) {
    }

    public void visit(Table tableName) {
    }

    class SqlRefactor {
        SqlRefactor() {
        }

        public void handleSelect(PlainSelect plainSelect) {
            List joins;
            ArrayList<String> tableList = new ArrayList<String>(3);
            FromItem fromItem = plainSelect.getFromItem();
            if (fromItem == null) {
                return;
            }
            if (fromItem instanceof Table) {
                String temp = this.handleTableNameReturnColumnPrefix((Table)fromItem);
                tableList.add(temp);
            }
            if ((joins = plainSelect.getJoins()) != null) {
                for (Object join : joins) {
                    String temp = this.handleJoin((Join)join);
                    if (temp == null) continue;
                    tableList.add(temp);
                }
            }
            if (this.handleColumn()) {
                plainSelect.setWhere(this.refactWhere(tableList, plainSelect.getWhere()));
            }
        }

        private Expression refactWhere(List<String> tableList, Expression where) {
            Expression exp = where;
            if (exp != null) {
                exp = new Parenthesis(exp);
            }
            for (String prefix : tableList) {
                exp = this.computeNewExp(exp, prefix);
            }
            return exp;
        }

        private Expression computeNewExp(Expression exp, String name) {
            EqualsTo eq = new EqualsTo();
            eq.setLeftExpression((Expression)new Column(new Table(name), tenantColumnName));
            eq.setRightExpression((Expression)this.getTenantIdExpression());
            if (exp == null) {
                exp = eq;
            } else {
                AndExpression ex = new AndExpression((Expression)eq, exp);
                exp = ex;
            }
            return exp;
        }

        private String handleJoin(Join join) {
            if (join.isSimple()) {
                FromItem rightItem = join.getRightItem();
                if (rightItem instanceof Table) {
                    return this.handleTableNameReturnColumnPrefix((Table)rightItem);
                }
                return null;
            }
            if (join.getRightItem() instanceof Table) {
                String prefix = this.handleTableNameReturnColumnPrefix((Table)join.getRightItem());
                if (this.handleColumn()) {
                    Expression exp = join.getOnExpression();
                    exp = this.computeNewExp(exp, prefix);
                    join.setOnExpression(exp);
                }
                return null;
            }
            return null;
        }

        private String handleTableNameReturnColumnPrefix(Table tb) {
            if (tb.getSchemaName() != null) {
                throw new RuntimeException("In multi tenant envirment, Tables can't has schema. but find " + tb.getSchemaName() + " from table " + tb.getName());
            }
            tb.setSchemaName(SqlHandlerVisitorForMixed.this.schemaName);
            if (tb.getAlias() != null) {
                return tb.getAlias().getName();
            }
            if (tb.getSchemaName() != null) {
                return tb.getSchemaName() + "." + tb.getName();
            }
            return tb.getName();
        }

        public void handleCreateTable(SqlHandlerVisitorForMixed sqlHandlerVisitor, CreateTable createTable) {
            if (StringKit.isNotNull(SqlHandlerVisitorForMixed.this.tenantId)) {
                throw new RuntimeException("Create Table not supported for share table mode now!");
            }
            if (StringKit.isNull(SqlHandlerVisitorForMixed.this.schemaName)) {
                throw new RuntimeException("Schema name must not null.");
            }
            if (StringKit.isNotNull(createTable.getTable().getSchemaName())) {
                throw new RuntimeException("Original Schema name must null.");
            }
            createTable.getTable().setSchemaName(SqlHandlerVisitorForMixed.this.schemaName);
        }

        public void handleTruncate(SqlHandlerVisitorForMixed sqlHandlerVisitor, Truncate truncate) {
        }

        public void handleDrop(SqlHandlerVisitorForMixed sqlHandlerVisitor, Drop drop) {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleReplace(SqlHandlerVisitorForMixed sqlHandlerVisitor, Replace insert) {
            Table table = insert.getTable();
            if (table == null) {
                throw new RuntimeException("table can't be null");
            }
            this.handleTableNameReturnColumnPrefix(table);
            if (!this.handleColumn()) return;
            insert.getColumns().add(new Column(new Table(), tenantColumnName));
            if (insert.isUseValues()) {
                ExpressionList exlist = (ExpressionList)insert.getItemsList();
                this.handleExpressionListForInsertReplace((ItemsList)exlist);
                return;
            } else {
                ItemsList items = insert.getItemsList();
                if (!(items instanceof SubSelect)) throw new RuntimeException("not support now");
                SubSelect ss = (SubSelect)items;
                SelectBody body = ss.getSelectBody();
                if (!(body instanceof PlainSelect)) throw new RuntimeException("Not support now");
                PlainSelect ps = (PlainSelect)body;
                this.handleSelectItemForInsert(ps);
            }
        }

        public void handleInsert(SqlHandlerVisitorForMixed sqlHandlerVisitor, Insert insert) {
            Table table = insert.getTable();
            if (table == null) {
                throw new RuntimeException("table can't be null");
            }
            this.handleTableNameReturnColumnPrefix(table);
            if (this.handleColumn()) {
                insert.getColumns().add(new Column(new Table(), tenantColumnName));
                if (insert.isUseValues()) {
                    ItemsList itemList = insert.getItemsList();
                    this.handleExpressionListForInsertReplace(itemList);
                } else {
                    Select select = insert.getSelect();
                    SelectBody body = select.getSelectBody();
                    if (body instanceof PlainSelect) {
                        this.handleSelectItemForInsert((PlainSelect)body);
                    } else if (body instanceof SetOperationList) {
                        SetOperationList u = (SetOperationList)body;
                        for (Object s : u.getSelects()) {
                            this.handleSelectItemForInsert((PlainSelect)s);
                        }
                    } else {
                        throw new RuntimeException("error gramma");
                    }
                }
            }
        }

        private void handleExpressionListForInsertReplace(ItemsList itemList) {
            if (itemList instanceof ExpressionList) {
                ExpressionList exlist = (ExpressionList)itemList;
                exlist.getExpressions().add(this.getTenantIdExpression());
            } else if (itemList instanceof MultiExpressionList) {
                MultiExpressionList mlist = (MultiExpressionList)itemList;
                for (ExpressionList l : mlist.getExprList()) {
                    l.getExpressions().add(this.getTenantIdExpression());
                }
            }
        }

        private void handleSelectItemForInsert(PlainSelect s) {
            SelectExpressionItem exi = new SelectExpressionItem();
            exi.setExpression((Expression)this.getTenantIdExpression());
            s.getSelectItems().add(exi);
        }

        private boolean handleColumn() {
            return StringKit.isNotNull(SqlHandlerVisitorForMixed.this.tenantId);
        }

        private StringValue getTenantIdExpression() {
            return new StringValue("'" + SqlHandlerVisitorForMixed.this.tenantId + "'");
        }

        public void handleUpdate(Update update) {
            List tables = update.getTables();
            ArrayList<String> tableList = new ArrayList<String>(3);
            for (Table table : tables) {
                if (table == null) {
                    throw new RuntimeException("table can't be null");
                }
                String prefix = this.handleTableNameReturnColumnPrefix(table);
                tableList.add(prefix);
            }
            if (this.handleColumn()) {
                update.setWhere(this.refactWhere(tableList, update.getWhere()));
            }
        }

        public void handleDelete(Delete delete) {
            Table table = delete.getTable();
            if (table == null) {
                throw new RuntimeException("table can't be null");
            }
            String prefix = this.handleTableNameReturnColumnPrefix(table);
            ArrayList<String> tableList = new ArrayList<String>(1);
            tableList.add(prefix);
            if (this.handleColumn()) {
                delete.setWhere(this.refactWhere(tableList, delete.getWhere()));
            }
        }
    }
}

