/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.mtenant.handler;

import java.sql.Connection;
import java.sql.SQLException;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.das.api.sqlrefactor.ISqlRefactor;
import net.jplugin.core.das.dds.impl.DummyConnection;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.log.api.LogFactory;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.mtenant.handler.MultiDbSqlHelper;

public class SqlMultiTenantHanlderSchemaImpl
implements ISqlRefactor {
    private static Logger logger = LogFactory.getLogger(SqlMultiTenantHanlderSchemaImpl.class);
    private boolean allDataSource;
    private String[] dataSources = null;
    boolean init;

    public void init() {
        if (!this.init) {
            this.init = true;
            String datasource = ConfigFactory.getStringConfig("mtenant.datasource", "ALL");
            if ("ALL".equals(datasource)) {
                this.allDataSource = true;
            } else {
                this.allDataSource = false;
                this.dataSources = StringKit.splitStr(datasource, ",");
            }
        }
    }

    @Override
    public String refactSql(String dataSourceName, String sql, Connection conn) {
        this.init();
        String result = this.handleInner(dataSourceName, sql, conn);
        if (logger.isDebugEnabled() && !sql.equals(result)) {
            logger.debug("BeforeSQL = " + sql);
            logger.debug("After SQL = " + result);
        }
        return result;
    }

    public String handleInner(String dataSourceName, String sql, Connection conn) {
        if (!this.allDataSource && !this.inDataSourceList(dataSourceName)) {
            return sql;
        }
        boolean isRouter = false;
        try {
            isRouter = conn.isWrapperFor(DummyConnection.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while call isWrapper", e);
        }
        if (isRouter) {
            throw new RuntimeException("Router connection can't be configed with multinant." + conn.getClass().getName());
        }
        String tid = ThreadLocalContextManager.getRequestInfo().getCurrentTenantId();
        String schemaPrefix = ConfigFactory.getStringConfig("mtenant.schema-prefix." + dataSourceName);
        if (StringKit.isNull(schemaPrefix)) {
            throw new RuntimeException("The multi tenant datasource [" + dataSourceName + "] must be configed with a [schema-prefix." + dataSourceName + "] key");
        }
        if (StringKit.isNull(tid)) {
            throw new RuntimeException("The multi tenant datasource [" + dataSourceName + "] must be called with a tenantid request attribute");
        }
        String schema = schemaPrefix + "_" + tid;
        return MultiDbSqlHelper.handle(sql, schema);
    }

    private void setSchema(Connection conn, String schema) throws SQLException {
        conn.setSchema(schema);
    }

    private boolean inDataSourceList(String dataSourceName) {
        for (String s : this.dataSources) {
            if (!s.equals(dataSourceName)) continue;
            return true;
        }
        return false;
    }
}

