/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.mtenant.handler;

import java.util.ArrayList;
import net.jplugin.core.das.kits.SqlWordsWalker;

public class MultiDbSqlHelper {
    private static final String SELECT = "SELECT";
    private static final Object UPDATE = "UPDATE";
    private static final Object DELETE = "DELETE";
    private static final Object INSERT = "INSERT";

    public static String handle(String sql, String schema) {
        SqlWordsWalker walker = SqlWordsWalker.createFromSql(sql);
        String[] allList = walker.getArray();
        String[][] lists = MultiDbSqlHelper.splitLists(allList);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < lists.length; ++i) {
            String[] list = lists[i];
            MultiDbSqlHelper.handleOneSql(schema, list);
            if (i != 0) {
                buffer.append(" ");
            }
            MultiDbSqlHelper.appendToBuffer(buffer, list);
        }
        return buffer.toString();
    }

    private static String[][] splitLists(String[] allList) {
        boolean justOne = true;
        for (int i = 0; i < allList.length; ++i) {
            String s = allList[i];
            if (s.length() != 1 || s.charAt(0) != ';' || i == allList.length - 1) continue;
            justOne = false;
            break;
        }
        if (justOne) {
            return new String[][]{allList};
        }
        ArrayList<String[]> ret = new ArrayList<String[]>();
        int startPos = 0;
        for (int i = 0; i < allList.length; ++i) {
            String s = allList[i];
            if ((s.length() != 1 || s.charAt(0) != ';') && i != allList.length - 1) continue;
            String[] temp = new String[i - startPos + 1];
            System.arraycopy(allList, startPos, temp, 0, temp.length);
            ret.add(temp);
            startPos = i + 1;
        }
        String[][] retarr = new String[ret.size()][];
        return (String[][])ret.toArray((T[])retarr);
    }

    private static void handleOneSql(String schema, String[] list) {
        String command = null;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].startsWith("/*")) continue;
            command = list[i].toUpperCase();
            break;
        }
        if (command == null) {
            throw new RuntimeException("Error sql:" + MultiDbSqlHelper.toSql(list));
        }
        if (SELECT.equals(command)) {
            MultiDbSqlHelper.handleSelect(list, schema);
        } else if (UPDATE.equals(command)) {
            MultiDbSqlHelper.handleUpdate(list, schema);
            MultiDbSqlHelper.handleSelect(list, schema);
        } else if (DELETE.equals(command)) {
            MultiDbSqlHelper.handleSelect(list, schema);
        } else if (INSERT.equals(command)) {
            MultiDbSqlHelper.handleInsert(list, schema);
            MultiDbSqlHelper.handleSelect(list, schema);
        } else {
            throw new RuntimeException("Unsupported sql for MultiDbSqlHelper");
        }
    }

    private static void handleInsert(String[] list, String schema) {
        for (int i = 0; i < list.length; ++i) {
            if (!"INTO".equalsIgnoreCase(list[i])) continue;
            MultiDbSqlHelper.handleTableName(list, i + 1, schema);
            return;
        }
        throw new RuntimeException("Can't find INTO word in " + MultiDbSqlHelper.toSql(list));
    }

    private static void handleUpdate(String[] list, String schema) {
        for (int i = 0; i < list.length; ++i) {
            if (!"UPDATE".equalsIgnoreCase(list[i])) continue;
            MultiDbSqlHelper.handleTableName(list, i + 1, schema);
            return;
        }
        throw new RuntimeException("Can't find UPDATE word in " + MultiDbSqlHelper.toSql(list));
    }

    private static String toSql(String[] list) {
        return MultiDbSqlHelper.appendToBuffer(new StringBuffer(), list);
    }

    private static String appendToBuffer(StringBuffer sb, String[] list) {
        boolean first = true;
        for (String s : list) {
            if (first) {
                sb.append(s);
                first = false;
                continue;
            }
            if (s.equals("(")) {
                sb.append(s);
                continue;
            }
            sb.append(" ").append(s);
        }
        return sb.toString();
    }

    private static void handleSelect(String[] list, String schema) {
        for (int i = 0; i < list.length; ++i) {
            String word = list[i];
            if (!"FROM".equalsIgnoreCase(word) && !"JOIN".equalsIgnoreCase(word)) continue;
            MultiDbSqlHelper.handleFromOrJoin(list, schema, i);
        }
    }

    private static void handleFromOrJoin(String[] list, String schema, int startPos) {
        MultiDbSqlHelper.handleTableName(list, startPos + 1, schema);
        for (int i = startPos + 1; i < list.length; ++i) {
            String word = list[i];
            if (word.equals("(")) {
                int posEnd = MultiDbSqlHelper.getMatchingBranketPos(list, i);
                if ((i = posEnd + 1) >= list.length) {
                    return;
                }
                word = list[i];
            }
            if ("ORDER".equalsIgnoreCase(word) || "WHERE".equalsIgnoreCase(word) || "GROUP".equalsIgnoreCase(word) || "UNION".equalsIgnoreCase(word) || "LIMIT".equalsIgnoreCase(word) || ")".equalsIgnoreCase(word) || "UNION".equalsIgnoreCase(word)) {
                return;
            }
            if ("FROM".equalsIgnoreCase(word) || "JOIN".equalsIgnoreCase(word)) {
                return;
            }
            if (!",".equals(word) || "(".equals(list[i + 1])) continue;
            MultiDbSqlHelper.handleTableName(list, i + 1, schema);
        }
    }

    private static int getMatchingBranketPos(String[] list, int startPos) {
        int i;
        int leftBracketNum = 1;
        for (i = startPos + 1; i < list.length; ++i) {
            String word = list[i];
            if ("(".equals(word)) {
                ++leftBracketNum;
            }
            if (")".equals(word) && --leftBracketNum == 0) break;
        }
        if (i < list.length) {
            return i;
        }
        throw new RuntimeException("Can't find matching [)]  from index " + startPos + ", sql = " + MultiDbSqlHelper.toSql(list));
    }

    private static void handleTableName(String[] list, int i, String schema) {
        String word = list[i];
        if ("(".equals(word)) {
            return;
        }
        if (word.startsWith("/*")) {
            MultiDbSqlHelper.handleTableName(list, i + 1, schema);
        }
        if (word.indexOf(".") >= 0) {
            throw new RuntimeException("The table name to handle must not contain [.] ,but is " + word);
        }
        list[i] = schema + "." + word;
    }

    public static void main(String[] args) {
        MultiDbSqlHelper.doHandle("select * from table1", "sss");
        MultiDbSqlHelper.doHandle("select * from table1 where f1=1 and f2=2", "sss");
        MultiDbSqlHelper.doHandle("select * from table1,(select * from ttt) t2 where table1.a = t2.b", "sss");
        MultiDbSqlHelper.doHandle("select * from a,(select * from a)", "xxx");
        MultiDbSqlHelper.test();
    }

    private static void doHandle(String sql, String schema) {
        String ret = MultiDbSqlHelper.handle(sql, schema);
        System.out.println();
        System.out.println(sql + " ->");
        System.out.println(ret);
    }

    public static void test() {
        String sql = "select sr.userId ,st.userId from sso_role sr, sso_toke st where sr.userid=123 and sr.role_id in (select role_id from sso_role where app_id in (select app_id from sso_app where app_id=1))";
        MultiDbSqlHelper.doHandle(sql, "ssssss");
        sql = "select distinct s.* from sso_role r, sso_role_resource_mapping m,sso_resource s where r.role_id = m.role_id and s.resource_id= m.resource_id and r.status =1 and s.status !=2 and s.type = 1 and r.role_id in ( ? , ? , ? , ? ) order by s.name ";
        MultiDbSqlHelper.doHandle(sql, "ssssss");
        sql = "SELECT count ( sr.role_id)   FROM   sso_user_role_mapping su,sso_role sr   WHERE   sr.role_id=su.role_id   AND right(sr.role_code,6)='_a8min'        AND su.user_id =?";
        MultiDbSqlHelper.doHandle(sql, "ssssss");
        sql = "select create_date as createdate, modify_date as modifydate, work_state as workstate, sso as sso, platform_num as platformnum, status as status from sso_user where status!=2 order by user_id asc limit 0, 10";
        MultiDbSqlHelper.doHandle(sql, "ssssss");
        sql = "select count(u.user_id  ) from sso_user u inner join sso_user_role_mapping m on u.user_id=m.user_id inner join sso_role r on r.role_id= m.role_id inner join sso_app a on a.app_id=r.app_id and r.role_code=?";
        MultiDbSqlHelper.doHandle(sql, "ssssss");
        sql = "SELECT sr1.app_id, sr1.role_id AS id, sr1.role_name AS NAME, CONCAT(sr1.app_id,sa1.app_code) AS pid, IF ( surm.user_id, 'true', 'false' ) AS checked,sr1.role_code as roleCode,sr1.platform_num sp,surm.platform_num sur,sa1.platform_num sap FROM sso_role sr1 ,sso_user_role_mapping surm , sso_app sa1 WHERE sr1.app_id = sa1.app_id AND sr1.`status` = 1 and sr1.role_id = surm.role_id AND surm.user_id =8";
        MultiDbSqlHelper.doHandle(sql, "ssssss");
        sql = "SELECT  count(1) FROM sso_role_resource_mapping m, sso_resource res,sso_app app WHERE m.resource_id = res.resource_id AND res.app_id = app.app_id AND m.role_id in (? ,?, ?, ? , ?, ?, ?, ?, ? , ? ) AND res.type = 4 AND app.app_code = ? AND res.url = ?";
        MultiDbSqlHelper.doHandle(sql, "ssssss");
    }
}

