/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.mtenant.dds;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.kernel.api.RefAnnotationSupport;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.log.api.RefLogger;
import net.jplugin.core.mtenant.MtenantStatus;

public class MultiTenantDDSHelper
extends RefAnnotationSupport {
    private Map<String, String> datasourceMap;
    private String dataSourceName;
    @RefLogger
    Logger logger;

    public void init(String ds, Map<String, String> config) {
        this.dataSourceName = ds;
        this.datasourceMap = new ConcurrentHashMap<String, String>();
    }

    public String computeTargetDataSource() {
        if (!MtenantStatus.enabled()) {
            throw new RuntimeException("The application is not in  multi-tenant status. can't use StaticTenantsDynamicDataSourceProvider");
        }
        String tid = ThreadLocalContextManager.getCurrentContext().getRequesterInfo().getCurrentTenantId();
        if (StringKit.isNull(tid)) {
            throw new RuntimeException("Got null tenantid when find dynamic datasoure:" + this.dataSourceName);
        }
        String key = tid;
        if (this.datasourceMap.containsKey(key)) {
            String result = this.datasourceMap.get(key);
            return result;
        }
        String result = this.getFromRemote(tid);
        if (result == null) {
            throw new RuntimeException("Got null tenantid from remote:" + this.dataSourceName);
        }
        if (this.dataSourceName.equals(result)) {
            throw new RuntimeException("Real ds and declared ds is same!");
        }
        this.datasourceMap.put(key, result);
        return result;
    }

    private String getFromRemote(String tid) {
        String path = this.dataSourceName + "." + "physical-ds";
        String physicalDss = ConfigFactory.getStringConfigWithTrim(path);
        if (StringKit.isNull(physicalDss)) {
            throw new RuntimeException("physical-ds must configured for dynamic datasource :" + this.dataSourceName);
        }
        String[] phyDsArr = StringKit.splitStr(physicalDss, ",");
        String targetDataSourceName = null;
        for (String ds : phyDsArr) {
            String temp = ConfigFactory.getStringConfig(ds + "-mtenant-cfg." + tid);
            if (temp == null) continue;
            if (targetDataSourceName != null) {
                throw new RuntimeException("Multi tenantstore policy found , tenant " + tid + " dds=" + this.dataSourceName);
            }
            targetDataSourceName = ds;
        }
        return targetDataSourceName;
    }

    public void clearCache() {
        this.logger.warn("\u914d\u7f6e\u53d1\u751f\u53d8\u5316\uff0c\u5237\u65b0\u591a\u79df\u6237\u52a8\u6001\u6570\u636e\u6e90\u6620\u5c04\u7f13\u5b58");
        this.datasourceMap.clear();
    }
}

