/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.mtenant.api;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import net.jplugin.core.das.mybatis.impl.sess.MybatisSessionManager;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.mtenant.MtenantStatus;
import net.jplugin.core.mtenant.api.TenantListProvidorManager;
import net.jplugin.core.mtenant.api.TenantResult;

public class TenantIteratorKit {
    public static List<TenantResult> execute(Runnable r) {
        return TenantIteratorKit.commonExecute(r, null);
    }

    public static List<TenantResult> execute(Callable c) {
        return TenantIteratorKit.commonExecute(c, null);
    }

    public static List<TenantResult> execute(Runnable r, List<String> tenantsList) {
        return TenantIteratorKit.commonExecute(r, tenantsList);
    }

    public static List<TenantResult> execute(Callable c, List<String> tenantsList) {
        return TenantIteratorKit.commonExecute(c, tenantsList);
    }

    private static List<TenantResult> commonExecute(Object runnableOrCallable, List<String> tenantsList) {
        if (MtenantStatus.enabled()) {
            if (TenantListProvidorManager.instance.isProviderExist()) {
                List<String> list = tenantsList != null ? tenantsList : TenantListProvidorManager.instance.getList();
                ArrayList<TenantResult> results = new ArrayList<TenantResult>(list.size());
                String oldTenantId = ThreadLocalContextManager.getRequestInfo().getCurrentTenantId();
                for (String t : list) {
                    ThreadLocalContextManager.getRequestInfo().setCurrentTenantId(t);
                    MybatisSessionManager.releaseSessions();
                    results.add(TenantIteratorKit.runAndGetResult(t, runnableOrCallable));
                }
                ThreadLocalContextManager.getRequestInfo().setCurrentTenantId(oldTenantId);
                MybatisSessionManager.releaseSessions();
                return results;
            }
            throw new RuntimeException("mtenant enabled and TenantListProvidor not configed, call TenantIteratorTemplate error");
        }
        ArrayList<TenantResult> results = new ArrayList<TenantResult>(1);
        results.add(TenantIteratorKit.runAndGetResult(null, runnableOrCallable));
        return results;
    }

    private static TenantResult runAndGetResult(String tid, Object runnableOrCallable) {
        try {
            if (runnableOrCallable instanceof Runnable) {
                ((Runnable)runnableOrCallable).run();
                return new TenantResult(tid, null, null);
            }
            Object r = ((Callable)runnableOrCallable).call();
            return new TenantResult(tid, r, null);
        }
        catch (Throwable t) {
            return new TenantResult(tid, null, t);
        }
    }
}

