/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.mtenant;

import net.jplugin.core.config.ExtensionConfigHelper;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.das.ExtensionDasHelper;
import net.jplugin.core.kernel.api.AbstractPlugin;
import net.jplugin.core.kernel.api.ExtensionKernelHelper;
import net.jplugin.core.kernel.api.ExtensionPoint;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.mtenant.MTenantChain;
import net.jplugin.core.mtenant.MtenantStatus;
import net.jplugin.core.mtenant.api.ITenantListProvidor;
import net.jplugin.core.mtenant.api.ITenantStoreStrategyProvidor;
import net.jplugin.core.mtenant.api.TenantListProvidorManager;
import net.jplugin.core.mtenant.dds.DDSConfigChangeHandler;
import net.jplugin.core.mtenant.dds.MultitenantDynamicDataSource;
import net.jplugin.core.mtenant.handler.SqlMultiTenantHanlderSchemaImpl;
import net.jplugin.core.mtenant.handler2.SqlHandlerVisitorForMixed;
import net.jplugin.core.mtenant.handler2.SqlMultiTenantHanlderMixedImpl;
import net.jplugin.core.mtenant.handler2.TenantStoreStrategyManager;
import net.jplugin.core.mtenant.tidv.TenantIDValidator;
import net.jplugin.ext.webasic.ExtensionWebHelper;
import net.jplugin.mtenant.impl.kit.SqlMultiTenantHanlderMergeImpl;

public class Plugin
extends AbstractPlugin {
    public static final String EP_TENANTLIST_PROVIDOR = "EP_TENANTLIST_PROVIDOR";
    public static final String EP_TENANT_STORESTG_PROVIDOR = "EP_TENANT_STORESTG_PROVIDOR";

    public Plugin() {
        MtenantStatus.init();
        this.addExtensionPoint(ExtensionPoint.create(EP_TENANTLIST_PROVIDOR, ITenantListProvidor.class));
        this.addExtensionPoint(ExtensionPoint.create(EP_TENANT_STORESTG_PROVIDOR, ITenantStoreStrategyProvidor.class));
        ExtensionDasHelper.addDynamisDataSourceTypeExtension(this, "mt-dds", MultitenantDynamicDataSource.class);
        if (MtenantStatus.enabled()) {
            this.registeSqlRefectorExtension();
            PluginEnvirement.INSTANCE.getStartLogger().log("@@@ mtenant ENABLED! req-param=" + ConfigFactory.getStringConfigWithTrim("mtenant.req-param-name") + " dbfield=" + ConfigFactory.getStringConfigWithTrim("mtenant.field"));
            ExtensionKernelHelper.addHttpClientFilterExtension(this, MTenantChain.class);
            ExtensionWebHelper.addServiceFilterExtension(this, TenantIDValidator.class);
            ExtensionWebHelper.addWebCtrlFilterExtension(this, TenantIDValidator.class);
            ExtensionConfigHelper.addConfigChangeHandlerExtension(this, "*", DDSConfigChangeHandler.class);
        } else {
            PluginEnvirement.INSTANCE.getStartLogger().log("@@@ mtenant DISABLED!");
        }
    }

    private void registeSqlRefectorExtension() {
        String s = ConfigFactory.getStringConfigWithTrim("mtenant.db-strategy");
        if (s == null) {
            s = "schema";
        }
        Class clazz = null;
        if ("schema".equals(s)) {
            clazz = SqlMultiTenantHanlderSchemaImpl.class;
        } else if ("merge".equals(s)) {
            clazz = SqlMultiTenantHanlderMergeImpl.class;
        } else if ("mixed".equals(s)) {
            clazz = SqlMultiTenantHanlderMixedImpl.class;
        } else {
            throw new RuntimeException("Error mtenant.db.strategy configed : " + s);
        }
        ExtensionDasHelper.addSqlRefactorExtension(this, clazz);
        PluginEnvirement.getInstance().getStartLogger().log("\u591a\u79df\u6237\u6570\u636e\u5e93\u7b56\u7565:" + s + "  " + clazz.getName());
    }

    @Override
    public void onCreateServices() {
        if (MtenantStatus.enabled()) {
            TenantIDValidator.init();
            TenantListProvidorManager.instance.init();
            TenantStoreStrategyManager.instance.init();
            SqlHandlerVisitorForMixed.init();
        }
    }

    @Override
    public int getPrivority() {
        return -9895;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean searchClazzForExtension() {
        return false;
    }
}

