/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.mtenant;

import java.util.HashMap;
import java.util.Map;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.filter.FilterChain;
import net.jplugin.common.kits.http.filter.HttpClientFilterContext;
import net.jplugin.common.kits.http.filter.IHttpClientFilter;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.config.api.RefConfig;
import net.jplugin.core.kernel.api.RefAnnotationSupport;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;

public class MTenantChain
extends RefAnnotationSupport
implements IHttpClientFilter {
    private String reqParamName = ConfigFactory.getStringConfig("mtenant.req-param-name");
    @RefConfig(defaultValue="true", path="mtenant.tenantid-inbody-for-comp-httpkit")
    private Boolean tenantIdInBodyForCompatible;

    @Override
    public Object filter(FilterChain fc, HttpClientFilterContext ctx) throws Throwable {
        String tid = ThreadLocalContextManager.getRequestInfo().getCurrentTenantId();
        if (StringKit.isNull(tid)) {
            return fc.next(ctx);
        }
        this.setHeader(ctx, tid);
        if (this.tenantIdInBodyForCompatible.booleanValue()) {
            HttpClientFilterContext.Method method = ctx.getMethod();
            if (method == HttpClientFilterContext.Method.POST || method == HttpClientFilterContext.Method.PUT) {
                this.handlePost(ctx, tid);
            } else if (method == HttpClientFilterContext.Method.GET || method == HttpClientFilterContext.Method.DELETE) {
                this.handleGet(ctx, tid);
            }
        }
        return fc.next(ctx);
    }

    private void setHeader(HttpClientFilterContext ctx, String tid) {
        Map<String, String> h = ctx.getHeaders();
        if (h == null) {
            h = new HashMap<String, String>();
            h.put("TenantId", tid);
            ctx.setHeaders(h);
        } else {
            h.put("TenantId", tid);
        }
    }

    private void handlePost(HttpClientFilterContext ctx, String tid) {
        if (ctx.getParams() == null) {
            ctx.setParams(new HashMap<String, Object>());
        }
        ctx.getParams().put(this.reqParamName, tid);
    }

    private void handleGet(HttpClientFilterContext ctx, String tid) {
        String url = ctx.getUrl();
        if (StringKit.isNull(url)) {
            throw new RuntimeException("Get url is null");
        }
        url = url.indexOf("?") > 0 ? url + "&" : url + "?";
        url = url + this.reqParamName + "=" + tid;
        ctx.setUrl(url);
    }
}

