/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.log.impl;

import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.log.impl.LoggerListCacher;
import net.jplugin.core.log.impl.helper.FormattingTuple;
import net.jplugin.core.log.impl.helper.MessageFormatter;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class Logger4Log4j
implements Logger {
    private static final String FQCN = Logger4Log4j.class.getName();
    org.apache.log4j.Logger logger;
    String logName;

    Logger4Log4j(org.apache.log4j.Logger l) {
        this.logger = l;
    }

    Logger4Log4j(String n) {
        this.logName = n;
        LoggerListCacher.add(this);
    }

    @Override
    public void debug(Object msg, Throwable t) {
        this.log(Level.DEBUG, msg, t);
    }

    @Override
    public void debug(Object msg) {
        this.log(Level.DEBUG, msg);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.log(Level.DEBUG, format, arguments);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    @Override
    public void error(Object message) {
        this.log(Level.ERROR, message);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.log(Level.ERROR, format, arguments);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    @Override
    public void fatal(String format, Object ... arguments) {
        this.log(Level.FATAL, arguments);
    }

    @Override
    public void fatal(Object message) {
        this.log(Level.FATAL, message);
    }

    @Override
    public final Level getLevel() {
        return this.getLogLevel();
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.log(Level.INFO, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLogEnabled((Priority)Level.DEBUG);
    }

    @Override
    public boolean isEnabledFor(Priority level) {
        return this.isLogEnabled(level);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLogEnabled((Priority)Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLogEnabled((Priority)Level.TRACE);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(Level.WARN, message, t);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARN, message);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.log(Level.WARN, format, arguments);
    }

    private Level getLogLevel() {
        if (this.logger == null) {
            return Level.DEBUG;
        }
        return this.logger.getLevel();
    }

    private boolean isLogEnabled(Priority level) {
        if (this.logger == null) {
            return true;
        }
        return this.logger.isEnabledFor(level);
    }

    private void log(Level level, Object message) {
        if (this.logger == null) {
            PluginEnvirement.INSTANCE.getStartLogger().log(message);
            return;
        }
        this.logger.log(FQCN, (Priority)level, message, null);
    }

    private void log(Level level, Object message, Throwable th) {
        if (this.logger == null) {
            PluginEnvirement.INSTANCE.getStartLogger().log(message, th);
            return;
        }
        this.logger.log(FQCN, (Priority)level, message, th);
    }

    private void log(Level level, String format, Object ... arguments) {
        if (this.logger == null) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            PluginEnvirement.INSTANCE.getStartLogger().log(ft.getMessage(), ft.getThrowable());
            return;
        }
        if (this.logger.isEnabledFor((Priority)level)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.logger.log(FQCN, (Priority)level, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    void createLogger() {
        this.logger = org.apache.log4j.Logger.getLogger((String)this.logName);
    }
}

