/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.jplugin.common.kits.Comparor;
import net.jplugin.common.kits.SortUtil;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.AbstractPlugin;
import net.jplugin.core.kernel.api.Extension;
import net.jplugin.core.kernel.api.ExtensionPoint;
import net.jplugin.core.kernel.api.IPlugin;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.PluginError;
import net.jplugin.core.kernel.api.plugin_event.PluginEventListenerManager;

public class PluginRegistry {
    private List<AbstractPlugin> pluginList = new Vector<AbstractPlugin>();
    private List<PluginError> errorList = new Vector<PluginError>();
    private Hashtable<String, ExtensionPoint> extensionPointMap = new Hashtable();
    private Map<String, AbstractPlugin> loadedPluginMap = new Hashtable<String, AbstractPlugin>();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.pluginList.size(); ++i) {
            sb.append("\n");
            sb.append(this.pluginList.get(i));
        }
        return sb.toString();
    }

    public List<PluginError> getErrors() {
        return this.errorList;
    }

    public List<AbstractPlugin> getPluginList() {
        return Collections.unmodifiableList(this.pluginList);
    }

    public void addPlugin(IPlugin plugin) {
        this.pluginList.add((AbstractPlugin)plugin);
    }

    public void afterPluginsContruct() {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin p = this.pluginList.get(i);
            p.afterPluginsContruct();
        }
    }

    public void sort() {
        this.checkSameName(this.errorList);
        SortUtil.sort(this.pluginList, new Comparor(){

            @Override
            public boolean isGreaterThen(Object o1, Object o2) {
                AbstractPlugin p1 = (AbstractPlugin)o1;
                AbstractPlugin p2 = (AbstractPlugin)o2;
                if (p1.getPrivority() > p2.getPrivority()) {
                    return true;
                }
                if (p1.getPrivority() < p2.getPrivority()) {
                    return false;
                }
                int nameCompResult = StringKit.compare(p1.getName(), p2.getName());
                if (nameCompResult == 0) {
                    throw new RuntimeException("shoudln't come here");
                }
                return nameCompResult > 0;
            }
        });
    }

    public void valid() {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin p = this.pluginList.get(i);
            List<PluginError> ret = p.valid(this);
            if (ret.isEmpty()) continue;
            p.setStatus(-1);
            this.errorList.addAll(ret);
        }
    }

    public void load() {
        AbstractPlugin plugin;
        int i;
        for (i = 0; i < this.pluginList.size(); ++i) {
            plugin = this.pluginList.get(i);
            if (plugin.getStatus() != 0) continue;
            List<PluginError> ret = plugin.load();
            if (ret != null && !ret.isEmpty()) {
                plugin.setStatus(-1);
                this.errorList.addAll(ret);
                continue;
            }
            plugin.setStatus(1);
        }
        for (i = 0; i < this.pluginList.size(); ++i) {
            plugin = this.pluginList.get(i);
            this.loadedPluginMap.put(plugin.getName(), plugin);
        }
    }

    public void wire() {
        this.extensionPointMap.clear();
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin plugin = this.pluginList.get(i);
            if (plugin.getStatus() != 1) continue;
            plugin.wire(this, this.errorList);
        }
    }

    public void makeServices() {
        PluginEnvirement.INSTANCE.getStartLogger().log("==Now to create services==");
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin plugin = this.pluginList.get(i);
            if (plugin.getStatus() != 1) continue;
            plugin.onCreateServices();
            PluginEventListenerManager.afterCreateServices(plugin.getName());
        }
    }

    public void start(boolean testAll, String testTarget) {
        PluginEnvirement.INSTANCE.getStartLogger().log("==Now to init plugins==");
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin plugin = this.pluginList.get(i);
            if (plugin.getStatus() != 1) continue;
            try {
                PluginEnvirement.INSTANCE.getStartLogger().log("StartPlugin :[" + i + "] " + plugin.getName());
                plugin.init();
                if (testAll || !plugin.getName().equals(testTarget)) continue;
                break;
            }
            catch (Exception e) {
                this.errorList.add(new PluginError(plugin.getName(), "error when start," + e.getMessage(), e));
                throw new RuntimeException("error to start:" + plugin.getName(), e);
            }
        }
        PluginEnvirement.INSTANCE.getStartLogger().log("Total " + this.pluginList.size() + " plugin started!");
    }

    private void checkSameName(List<PluginError> eList) {
        HashMap<String, IPlugin> tmp = new HashMap<String, IPlugin>();
        for (int i = 0; i < this.pluginList.size(); ++i) {
            IPlugin p = this.pluginList.get(i);
            String name = p.getName();
            if (StringKit.isNull(name)) {
                eList.add(new PluginError("null", "plugin name is null"));
                continue;
            }
            if (tmp.get(name) != null) {
                eList.add(new PluginError(name, "plugin same name with privious,removed"));
                continue;
            }
            tmp.put(name, p);
        }
    }

    public Map<String, ExtensionPoint> getExtensionPointMap() {
        return this.extensionPointMap;
    }

    public IPlugin getLoadedPlugin(String nm) {
        AbstractPlugin ret = this.loadedPluginMap.get(nm);
        if (ret == null) {
            throw new RuntimeException("the plugin not load correctly :" + nm);
        }
        return ret;
    }

    public void destroy() {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin plugin = this.pluginList.get(i);
            try {
                plugin.onDestroy();
                continue;
            }
            catch (Exception e) {
                PluginEnvirement.INSTANCE.getStartLogger().log(e.getMessage(), e);
            }
        }
    }

    public void clearClassCache() {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin plugin = this.pluginList.get(i);
            plugin._cleanContainedClasses();
        }
    }

    public void handleDuplicateExtension() {
        HashSet<Extension> tempSet = new HashSet<Extension>();
        for (AbstractPlugin p : this.pluginList) {
            List<Extension> extList = p.getExtensions();
            for (int i = extList.size() - 1; i >= 0; --i) {
                Extension ext = extList.get(i);
                if (tempSet.contains(ext)) {
                    PluginEnvirement.getInstance().getStartLogger().log("Warnning: Found dup extension in plugin:" + p.getName() + " ext=" + ext);
                    extList.remove(i);
                    continue;
                }
                tempSet.add(ext);
            }
        }
        tempSet.clear();
    }
}

