/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.jplugin.common.kits.ExceptionKit;
import net.jplugin.common.kits.FileKit;
import net.jplugin.common.kits.PropertiesKit;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.kernel.api.Beans;
import net.jplugin.core.kernel.api.ConfigHelper;
import net.jplugin.core.kernel.api.CorePlugin;
import net.jplugin.core.kernel.api.ExtPlugin;
import net.jplugin.core.kernel.api.ExtensionPoint;
import net.jplugin.core.kernel.api.IPlugin;
import net.jplugin.core.kernel.api.IStartLogger;
import net.jplugin.core.kernel.api.IStartup;
import net.jplugin.core.kernel.api.PluginAutoDetect;
import net.jplugin.core.kernel.api.PluginError;
import net.jplugin.core.kernel.api.PluginFilterManager;
import net.jplugin.core.kernel.api.PluginRegistry;
import net.jplugin.core.kernel.api.PluginRuntimeException;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContext;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.kernel.impl.AnnotationResolveHelper;
import net.jplugin.core.kernel.impl.PluginPrepareHelper;
import net.jplugin.core.kernel.impl.StartUpLoggerImpl;

public class PluginEnvirement {
    public static final int STAT_LEVEL_PREPAREING = 0;
    public static final int STAT_LEVEL_LOADING = 10;
    public static final int STAT_LEVEL_WIRING = 20;
    public static final int STAT_LEVEL_MAKINGSVC = 25;
    public static final int STAT_LEVEL_INITING = 30;
    public static final int STAT_LEVEL_WORKING = 40;
    public static final String WORK_DIR = "work-dir";
    public static PluginEnvirement INSTANCE = new PluginEnvirement();
    private PluginRegistry registry = new PluginRegistry();
    String workdir = null;
    private AnnotationResolveHelper annoResolveHelper = new AnnotationResolveHelper(this);
    private int stateLevel = 0;
    private IStartLogger startLogger = new StartUpLoggerImpl();
    private boolean unitTesting = false;
    private PluginFilterManager<Tuple2<Boolean, String>> startFilterManager = new PluginFilterManager<Tuple2>("EP_PLUGIN_ENV_INIT_FILTER", (fc, ctx) -> {
        this.registry.start((Boolean)ctx.first, (String)ctx.second);
        return null;
    });
    String configDir = null;
    String webRootPath = null;
    boolean started = false;

    public static PluginEnvirement getInstance() {
        return INSTANCE;
    }

    public void initStartFilter() {
        this.startFilterManager.init();
    }

    public IStartLogger getStartLogger() {
        return this.startLogger;
    }

    public int getStateLevel() {
        return this.stateLevel;
    }

    public boolean isUnitTesting() {
        return this.unitTesting;
    }

    public void setUnitTesting(boolean unitTesting) {
        this.unitTesting = unitTesting;
    }

    public void stop() {
        INSTANCE.getStartLogger().log("$$$ now to stop plugin envirment");
        this.registry.destroy();
        this.registry = new PluginRegistry();
        this.started = false;
        INSTANCE.getStartLogger().log("$$$ plugin envirment stopped");
    }

    public PluginRegistry getPluginRegistry() {
        return this.registry;
    }

    public boolean getStarted() {
        return this.started;
    }

    public boolean hasExtensionPoint(String pointName) {
        ExtensionPoint point = this.registry.getExtensionPointMap().get(pointName);
        return point != null;
    }

    public ExtensionPoint getExtensionPoint(String pointName) {
        ExtensionPoint point = this.registry.getExtensionPointMap().get(pointName);
        if (point == null) {
            throw new PluginRuntimeException("Can't find the point:" + pointName);
        }
        return point;
    }

    public Object[] getExtensionObjects(String pointName) {
        return this.getExtensionObjects(pointName, Object.class);
    }

    public <T> Map<String, T> getExtensionMap(String pointName, Class<T> type) {
        return this.getExtensionMap(pointName);
    }

    public Map<String, Object> getExtensionMap(String pointName) {
        ExtensionPoint point = this.registry.getExtensionPointMap().get(pointName);
        if (point == null) {
            throw new PluginRuntimeException("Can't find the extension point:" + pointName);
        }
        return point.getExtensionMap();
    }

    public <T> T getExtension(String pointName, Class<T> t) {
        ExtensionPoint point = this.registry.getExtensionPointMap().get(pointName);
        if (point == null) {
            throw new PluginRuntimeException("Can't find the extension point:" + pointName);
        }
        return point.getExtension(t);
    }

    public <T> T[] getExtensionObjects(String pointName, Class<T> t) {
        ExtensionPoint point = this.registry.getExtensionPointMap().get(pointName);
        if (point == null) {
            throw new PluginRuntimeException("Can't find the extension point:" + pointName);
        }
        return point.getExtensionObjects(t);
    }

    public void setWorkDir(String dir) {
        this.workdir = dir;
    }

    public String getWorkDir() {
        if (this.workdir == null) {
            this.workdir = System.getProperty(WORK_DIR, "./nswork");
        }
        return this.workdir;
    }

    public synchronized String getConfigDir() {
        if (this.configDir == null) {
            this.configDir = PluginEnvirement.class.getClassLoader().getResource("").getFile() + "config";
        }
        return this.configDir;
    }

    public void setConfigDir(String dir) {
        this.configDir = dir;
    }

    public void setWebRootPath(String s) {
        this.webRootPath = s;
    }

    public String getWebRootPath() {
        return this.webRootPath;
    }

    public synchronized void startup() {
        this.startup(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startup(Set plgns) {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            INSTANCE.getStartLogger().log("$$$ ConfigDir=" + this.getConfigDir());
            INSTANCE.getStartLogger().log("$$$ WorkDir=" + this.getWorkDir());
            PluginAutoDetect.addAutoDetectPackage("net.jplugin.extension");
            PluginAutoDetect.addAutoDetectPackage("net.jplugin.app");
            HashSet<Object> pluginToLoad = new HashSet<Object>();
            if (plgns == null) {
                if (FileKit.existsFile(this.getConfigDir() + "/plugin.cfg")) {
                    Properties prop = PropertiesKit.loadProperties(this.getConfigDir() + "/plugin.cfg");
                    pluginToLoad.addAll(prop.keySet());
                }
                pluginToLoad.addAll(CorePlugin.get());
                pluginToLoad.addAll(ExtPlugin.get());
                pluginToLoad.addAll(PluginAutoDetect.get(pluginToLoad));
            } else {
                pluginToLoad.addAll(plgns);
            }
            boolean testAll = false;
            String testTarget = null;
            testTarget = System.getProperty("testTarget");
            if ("true".equals(System.getProperty("testAll"))) {
                testAll = true;
            }
            PluginPrepareHelper.preparePlugins(pluginToLoad);
            for (Object e : pluginToLoad) {
                this.addPlugin(e);
                if (testAll) {
                    this.addPluginIfExists("test." + e);
                    continue;
                }
                if (!("test." + e).equals(testTarget)) continue;
                this.addPluginIfExists("test." + e);
            }
            this.registry.afterPluginsContruct();
            this.registry.sort();
            this.registry.handleDuplicateExtension();
            this.registry.valid();
            this.stateLevel = 10;
            this.registry.load();
            Beans.initFromPluginList();
            this.stateLevel = 20;
            this.registry.wire();
            this.stateLevel = 25;
            this.registry.makeServices();
            this.registry.clearClassCache();
            this.stateLevel = 30;
            if (this.registry.getErrors() == null || this.registry.getErrors().isEmpty()) {
                try {
                    ThreadLocalContext ctx = ThreadLocalContextManager.instance.createContext();
                    this.annoResolveHelper.resolveHistory();
                    this.startFilterManager.filter(Tuple2.with(testAll, testTarget));
                }
                finally {
                    ThreadLocalContextManager.instance.releaseContext();
                }
            }
            if (this.registry.getErrors() == null || this.registry.getErrors().isEmpty()) {
                this.trigStartListener(null, null);
                this.logStart(this.registry.getErrors());
            } else {
                this.trigStartListener(null, this.registry.getErrors());
                this.logStart(this.registry.getErrors());
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(-2);
            }
            this.stateLevel = 40;
        }
        catch (Throwable e) {
            e = ExceptionKit.getRootCause(e);
            INSTANCE.getStartLogger().log("\u521d\u59cb\u5316\u8fc7\u7a0b\u53d1\u751f\u9519\u8bef", e);
            if (PluginEnvirement.getInstance().hasExtensionPoint("EP_STARTUP")) {
                this.trigStartListener(e, null);
            }
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(-2);
        }
    }

    private void addPluginIfExists(Object obj) {
        String cname = (String)obj;
        try {
            Class.forName(cname);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        this.addPlugin(obj);
    }

    private void addPlugin(Object obj) {
        Object plugin;
        String cname = (String)obj;
        try {
            plugin = Class.forName(cname).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("plugin instance create error," + e.getMessage() + obj, e);
        }
        this.registry.addPlugin((IPlugin)plugin);
    }

    private void trigStartListener(Throwable e, List<PluginError> errors) {
        IStartup[] listeners = this.getExtensionObjects("EP_STARTUP", IStartup.class);
        if (e == null && errors == null) {
            for (int i = listeners.length - 1; i >= 0; --i) {
                IStartup s = listeners[i];
                s.startSuccess();
            }
        } else {
            for (int i = listeners.length - 1; i >= 0; --i) {
                IStartup s = listeners[i];
                s.startFailed(e, errors);
            }
        }
    }

    public ConfigHelper getConfigHelper(String pluginname) {
        return new ConfigHelper(this.registry.getLoadedPlugin(pluginname).getConfigures());
    }

    private void logStart(List<PluginError> errors) {
        if (errors == null || errors.size() == 0) {
            INSTANCE.getStartLogger().log("@@Plugin Loaded successfully!");
        } else {
            INSTANCE.getStartLogger().log("@@Plugin Loaded with errors ");
            for (PluginError e : errors) {
                INSTANCE.getStartLogger().log(e.toString());
            }
        }
    }

    public void resolveRefAnnotation(Object o) {
        this.annoResolveHelper.resolveOne(o);
    }

    public String getEnvType() {
        return System.getProperty("plugin.env");
    }

    public String getLogDir() {
        return this.getWorkDir() + "/logs";
    }
}

