/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.Extension;

public class ExtensionPoint {
    String name;
    Class<?> extensionClass;
    Type type;
    List<Extension> extensions;
    Object[] extensionObjects;
    Map<String, Object> extensionMap;

    public static ExtensionPoint createListed(String aName, Class<?> clazz) {
        return new ExtensionPoint(aName, clazz, Type.LISTED);
    }

    public static ExtensionPoint createNamed(String aName, Class<?> clazz) {
        return new ExtensionPoint(aName, clazz, Type.NAMED);
    }

    public static ExtensionPoint createSingleton(String aName, Class<?> clazz) {
        return new ExtensionPoint(aName, clazz, Type.SINGLETON);
    }

    @Deprecated
    public static ExtensionPoint create(String aName, Class<?> clazz) {
        return ExtensionPoint.createListed(aName, clazz);
    }

    @Deprecated
    public static ExtensionPoint create(String aName, Class<?> clazz, boolean nameUnique) {
        if (nameUnique) {
            return ExtensionPoint.createNamed(aName, clazz);
        }
        return ExtensionPoint.createListed(aName, clazz);
    }

    private ExtensionPoint(String aName, Class<?> clazz, Type tp) {
        this.name = aName;
        this.extensionClass = clazz;
        this.extensions = new ArrayList<Extension>();
        this.type = tp;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getExtensionClass() {
        return this.extensionClass;
    }

    public boolean extensionNameReqiredAndUnique() {
        return this.type == Type.NAMED;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public void addExtension(Extension e) {
        this.extensions.add(e);
    }

    public <T> T getExtension(Class<T> t) {
        if (this.type != Type.SINGLETON) {
            throw new RuntimeException("can't call getExtension when type is not SINGLETON");
        }
        if (this.extensionObjects == null) {
            this.getExtensionObjects(t);
        }
        if (this.extensionObjects == null || this.extensionObjects.length == 0) {
            return null;
        }
        return (T)this.extensionObjects[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] getExtensionObjects(Class<T> t) {
        if (this.extensionObjects == null) {
            ExtensionPoint extensionPoint = this;
            synchronized (extensionPoint) {
                if (this.extensionObjects == null) {
                    this.extensionObjects = (Object[])Array.newInstance(this.extensionClass, this.extensions.size());
                    for (int i = 0; i < this.extensionObjects.length; ++i) {
                        this.extensionObjects[i] = this.extensions.get(i).getObject();
                    }
                }
            }
        }
        return this.extensionObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getExtensionMap() {
        if (this.type != Type.NAMED) {
            throw new RuntimeException("can't call getExtensionMap when extensionNameReqiredAndUnique is false");
        }
        if (this.extensionMap == null) {
            ExtensionPoint extensionPoint = this;
            synchronized (extensionPoint) {
                if (this.extensionMap == null) {
                    this.extensionMap = new HashMap<String, Object>();
                    for (Extension e : this.extensions) {
                        this.extensionMap.put(e.getName(), e.getObject());
                    }
                }
            }
        }
        return this.extensionMap;
    }

    boolean validToAddExtensionByName(String nm) {
        if (this.type == Type.NAMED) {
            if (StringKit.isNull(nm)) {
                return false;
            }
            for (Extension e : this.extensions) {
                if (!nm.equals(e.getName())) continue;
                return false;
            }
            return true;
        }
        if (this.type == Type.SINGLETON) {
            return this.extensions.size() == 0;
        }
        return true;
    }

    public static enum Type {
        NAMED,
        LISTED,
        SINGLETON;

    }
}

