/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.ReflactKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.IPropertyFilter;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.impl.PropertyUtil;

public class Extension {
    public static IPropertyFilter propertyFilter = null;
    String refExtensionPoint;
    String name;
    Class clazz;
    Vector<Property> propertyList = new Vector(1);
    Object extensionObject;
    private String id;

    public String toString() {
        StringBuffer sb = new StringBuffer("refPoint:" + this.refExtensionPoint + " clazz:" + this.clazz.getName() + " name:" + this.name);
        sb.append(" property:[");
        for (int i = 0; i < this.propertyList.size(); ++i) {
            sb.append(this.propertyList.get((int)i).key + "-" + this.propertyList.get((int)i).value);
            sb.append("  ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        return (this.refExtensionPoint + this.clazz.getName() + this.name).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Extension)) {
            return false;
        }
        Extension e = (Extension)obj;
        return this.clazz.equals(e.getClazz()) && this.refExtensionPoint.equals(e.refExtensionPoint) && StringKit.eqOrNull(this.name, e.name) && this.checkPropertyDup(this.propertyList, e.propertyList) && StringKit.eqOrNull(this.id, e.id);
    }

    private boolean checkPropertyDup(Vector<Property> p1, Vector<Property> p2) {
        if (p1.size() != p2.size()) {
            return false;
        }
        for (Property item : p1) {
            boolean found = false;
            for (Property o : p2) {
                if (!StringKit.eqOrNull(item.key, o.key) || !StringKit.eqOrNull(item.value, o.value)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public String getExtensionPointName() {
        return this.refExtensionPoint;
    }

    public String getName() {
        return this.name;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public List<Property> getProperties() {
        return this.propertyList;
    }

    public Object getObject() {
        return this.extensionObject;
    }

    public synchronized void load() throws Exception {
        if (propertyFilter != null) {
            this.filterProperty(this.propertyList);
        }
        if (this.extensionObject == null) {
            if (this.clazz.equals(String.class)) {
                if (this.propertyList.size() != 1) {
                    throw new RuntimeException("String type extension must has one property with the val");
                }
                this.extensionObject = this.propertyList.get(0).getValue();
            } else {
                this.extensionObject = this.clazz.newInstance();
                PluginEnvirement.getInstance().resolveRefAnnotation(this.extensionObject);
                if (this.propertyList.size() > 0) {
                    Extension.setProperty(this.extensionObject, this.propertyList);
                }
            }
        }
    }

    private void filterProperty(Vector<Property> list) {
        for (Property p : list) {
            p.setValue(propertyFilter.filte(p.getValue()));
        }
    }

    private static void setProperty(Object o, Vector<Property> p) {
        Method method = null;
        try {
            method = o.getClass().getMethod("setExtensionProperty", List.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method != null) {
            ReflactKit.invoke(o, "setExtensionProperty", new Object[]{p});
        } else {
            PropertyUtil.setProperties(o, p);
        }
    }

    public static Extension createStringExtension(String aPointName, String value) {
        return Extension.create(aPointName, "", String.class, new String[][]{{"StringValue", value}});
    }

    public static Extension create(String aPointName, Class cls) {
        return Extension.create(aPointName, "", cls);
    }

    public static Extension create(String aPointName, String aName, Class cls) {
        return Extension.create(aPointName, aName, cls, null);
    }

    public static Extension create(String aPointName, Class cls, String[][] property) {
        return Extension.create(aPointName, "", cls, property);
    }

    public static Extension create(String aPointName, String aName, Class cls, String[][] property) {
        Extension ext = new Extension();
        ext.name = aName;
        ext.clazz = cls;
        ext.refExtensionPoint = aPointName;
        if (property != null) {
            for (int i = 0; i < property.length; ++i) {
                Property p = new Property();
                p.key = property[i][0];
                p.value = property[i][1];
                ext.propertyList.add(p);
            }
        }
        return ext;
    }

    public String getId() {
        return this.id;
    }

    void setId(String o) {
        this.id = o;
    }

    public static void main(String[] args) {
        Extension e1 = Extension.create("a", Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        Extension e2 = Extension.create("a", Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        AssertKit.assertTrue(e1.equals(e2));
        e1 = Extension.create("a", Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        e2 = Extension.create("a", Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v3"}});
        AssertKit.assertFalse(e1.equals(e2));
        e1 = Extension.create("a", null, Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        e2 = Extension.create("a", null, Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        AssertKit.assertTrue(e1.equals(e2));
        e1 = Extension.create("a", null, Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        e2 = Extension.create("a", "b", Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        AssertKit.assertFalse(e1.equals(e2));
        e1 = Extension.create("a", Extension.class);
        e2 = Extension.create("a", Extension.class);
        AssertKit.assertTrue(e1.equals(e2));
        e1 = Extension.create("a", Extension.class);
        e2 = Extension.create("a", Extension.class);
        AssertKit.assertTrue(e1.equals(e2));
    }

    public static class Property {
        String key;
        String value;

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String v) {
            this.value = v;
        }
    }
}

