/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jplugin.core.kernel.api.AbstractPlugin;
import net.jplugin.core.kernel.api.IBindAnnotationTransformer;
import net.jplugin.core.kernel.api.IBindExtensionHandler;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class AutoBindExtensionManager {
    public static AutoBindExtensionManager INSTANCE = new AutoBindExtensionManager();
    private List<IBindExtensionHandler> handlers = new ArrayList<IBindExtensionHandler>();
    private Map<Class, IBindAnnotationTransformer> transformers = new HashMap<Class, IBindAnnotationTransformer>();

    private AutoBindExtensionManager() {
        this.handlers.add(new Handler4Transformers());
    }

    @Deprecated
    public void addBindExtensionHandler(IBindExtensionHandler h) {
        this.handlers.add(h);
    }

    public List<IBindExtensionHandler> getHandlers() {
        return this.handlers;
    }

    public void addBindExtensionTransformer(Class annoClass, IBindAnnotationTransformer bat) {
        this.transformers.put(annoClass, bat);
    }

    class Handler4Transformers
    implements IBindExtensionHandler {
        Handler4Transformers() {
        }

        @Override
        public void handle(AbstractPlugin p) {
            if (AutoBindExtensionManager.this.transformers.isEmpty()) {
                return;
            }
            p.filterContainedClassesByChecker(null, c -> {
                Annotation[] annos = c.getAnnotations();
                if (annos != null && annos.length != 0) {
                    for (Annotation a : annos) {
                        IBindAnnotationTransformer trans = (IBindAnnotationTransformer)AutoBindExtensionManager.this.transformers.get(a.annotationType());
                        if (trans == null) continue;
                        trans.transform(p, c, a);
                        this.addExtensionAndLog(p, c, a);
                    }
                }
                return false;
            });
        }

        private void addExtensionAndLog(AbstractPlugin p, Class c, Annotation a) {
            Method[] methods;
            StringBuffer sb = new StringBuffer("$$$ Auto add extension for ");
            sb.append(a.annotationType().getSimpleName());
            sb.append(" class=").append(c.getSimpleName());
            for (Method f : methods = a.annotationType().getDeclaredMethods()) {
                String name = f.getName();
                try {
                    Object v = f.invoke((Object)a, new Object[0]);
                    if (v.getClass().isArray()) {
                        sb.append(" " + name + "= { ");
                        sb.append(this.getArrayString(v));
                        sb.append(" }");
                        continue;
                    }
                    sb.append(" " + name + "=");
                    sb.append(v.toString());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Error when transorm anno." + sb.toString(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Error when transorm anno." + sb.toString(), e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Error when transorm anno." + sb.toString(), e);
                }
            }
            PluginEnvirement.getInstance().getStartLogger().log(sb);
        }

        private String getArrayString(Object array) {
            StringBuffer sb = new StringBuffer();
            int len = Array.getLength(array);
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(array, i);
                sb.append(obj).append("  ");
            }
            return sb.toString();
        }
    }
}

