/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel;

import java.io.File;
import net.jplugin.common.kits.FileKit;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class PluginApp {
    private static final String JPLUGIN_HOME_PROP = "jplugin.home";
    private static final String MAVEN_CONFIG_RELPATH = "/src/main/resources/config";
    private static final String CONFIG_RELPATH = "/application/config";
    private static final String WEB_RELPATH = "/application/web";
    private static final String MAVEN_WEB_RELPATH = "/src/main/webapp";

    public static void main(String[] args) {
        if (PluginEnvirement.getInstance().getStarted()) {
            return;
        }
        String jpluginHome = System.getProperty(JPLUGIN_HOME_PROP, ".");
        jpluginHome = new File(jpluginHome).getAbsolutePath();
        PluginEnvirement.INSTANCE.setWorkDir(jpluginHome);
        PluginEnvirement.INSTANCE.getStartLogger().log("$$$ plugin.home=" + PluginEnvirement.INSTANCE.getWorkDir());
        String configDir = jpluginHome + CONFIG_RELPATH;
        if (!FileKit.existsAndIsDir(configDir)) {
            configDir = jpluginHome + MAVEN_CONFIG_RELPATH;
        }
        if (!FileKit.existsAndIsDir(configDir)) {
            throw new RuntimeException("Can't find the config dir, jplugin.home is " + jpluginHome);
        }
        PluginEnvirement.INSTANCE.setConfigDir(configDir);
        String webDir = jpluginHome + WEB_RELPATH;
        if (!FileKit.existsAndIsDir(webDir)) {
            webDir = jpluginHome + MAVEN_WEB_RELPATH;
        }
        PluginEnvirement.getInstance().setWebRootPath(webDir);
        PluginEnvirement.getInstance().startup();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                PluginEnvirement.INSTANCE.stop();
            }
        });
    }
}

