/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.event.impl;

import java.util.LinkedList;
import java.util.Vector;
import net.jplugin.core.ctx.api.TransactionManager;
import net.jplugin.core.ctx.api.TransactionSync;
import net.jplugin.core.event.api.Channel;
import net.jplugin.core.event.api.Event;
import net.jplugin.core.event.api.EventConsumer;
import net.jplugin.core.event.impl.PostMemoryThreadPoolExecutor;
import net.jplugin.core.log.api.ILogService;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.service.api.ServiceFactory;

public class PostMemoryChannel
extends Channel {
    static long u = System.currentTimeMillis();
    ThreadLocal<TheTransactionSync> sync = new ThreadLocal<TheTransactionSync>(){

        @Override
        protected TheTransactionSync initialValue() {
            return new TheTransactionSync();
        }
    };
    public static Logger logger = null;

    @Override
    public Channel.ChannelType getChannelType() {
        return Channel.ChannelType.POST_MEMORY;
    }

    @Override
    public void sendEvent(Event e) {
        e.setId(PostMemoryChannel.nextUnique());
        TransactionManager txservice = ServiceFactory.getService(TransactionManager.class);
        TheTransactionSync thesync = this.sync.get();
        if (!txservice.containTransactionSync(thesync)) {
            txservice.addTransactionSync(thesync);
            thesync.clear();
        }
        thesync.add(e);
    }

    private static long nextUnique() {
        return ++u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger getMemoryEventLogger() {
        if (logger != null) return logger;
        Class<EventRunnable> clazz = EventRunnable.class;
        synchronized (EventRunnable.class) {
            if (logger != null) return logger;
            logger = ServiceFactory.getService(ILogService.class).getSpecicalLogger("mem-event.log");
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger;
        }
    }

    public class EventRunnable
    implements Runnable {
        private Event event;

        public EventRunnable(Event e) {
            this.event = e;
        }

        @Override
        public void run() {
            Vector cs = PostMemoryChannel.this.consumers;
            for (EventConsumer ec : cs) {
                this.consumeEvent(ec, this.event);
            }
        }

        private void consumeEvent(EventConsumer ec, Event e) {
            Logger log = PostMemoryChannel.getMemoryEventLogger();
            long begin = System.currentTimeMillis();
            log.info("start exec event:" + e.getId());
            ec.consume(e);
            log.info("end exec event:" + e.getId() + " dural = " + (System.currentTimeMillis() - begin));
        }
    }

    public class TheTransactionSync
    implements TransactionSync {
        LinkedList<Event> list = new LinkedList();

        public void add(Event e) {
            this.list.add(e);
        }

        public void clear() {
            this.list.clear();
        }

        @Override
        public void afterCompletion(boolean success, Throwable th) {
            if (success) {
                for (Event e : this.list) {
                    PostMemoryThreadPoolExecutor.instance.execute(new EventRunnable(e));
                }
            }
        }

        @Override
        public void beforeCompletion() {
        }
    }
}

