/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.event.impl;

import java.util.Hashtable;
import java.util.Vector;
import net.jplugin.core.event.api.Channel;
import net.jplugin.core.event.api.Event;
import net.jplugin.core.event.api.EventAliasDefine;
import net.jplugin.core.event.api.EventConsumer;
import net.jplugin.core.event.api.IEventFilter;
import net.jplugin.core.event.impl.ChannelFactory;

public class ChannelFacade
extends Channel {
    Hashtable<String, Boolean> eventTypesMap = new Hashtable();
    Hashtable<String, Vector<AliasAndFilter>> filterMapping = new Hashtable();
    Hashtable<String, Vector<Channel>> channelMap = new Hashtable();

    public void init(String[] eventTypes, EventAliasDefine[] typeAliases, EventConsumer[] consumers) {
        for (String string : eventTypes) {
            if (this.eventTypesMap.containsKey(string)) {
                throw new RuntimeException("Duplicated event type:e");
            }
            this.eventTypesMap.put(string, false);
        }
        for (EventAliasDefine eventAliasDefine : typeAliases) {
            if (!this.eventTypesMap.containsKey(eventAliasDefine.getEventType())) {
                throw new RuntimeException("Can't find event type [" + eventAliasDefine.getEventType() + "] for alias type [" + eventAliasDefine.getTypeAlias() + "]");
            }
            if (this.eventTypesMap.containsKey(eventAliasDefine.getTypeAlias())) {
                throw new RuntimeException("Error alias name [" + eventAliasDefine.getTypeAlias() + "],duplicate with event type");
            }
            try {
                this.addAdiasAndFilter(eventAliasDefine.getEventType(), new AliasAndFilter(eventAliasDefine.getTypeAlias(), (IEventFilter)eventAliasDefine.getFilterClass().newInstance()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (EventAliasDefine eventAliasDefine : typeAliases) {
            if (this.eventTypesMap.containsKey(eventAliasDefine.getTypeAlias())) {
                throw new RuntimeException("Duplicated event alias type:" + eventAliasDefine.getTypeAlias());
            }
            this.eventTypesMap.put(eventAliasDefine.getTypeAlias(), true);
        }
        for (EventConsumer eventConsumer : consumers) {
            if (!this.eventTypesMap.containsKey(eventConsumer.getTargetType())) {
                throw new RuntimeException("Can't find event type or event alias type for consumer:" + eventConsumer.getClass().getName());
            }
            this.addConsumerToChannel(eventConsumer);
        }
    }

    private void addAdiasAndFilter(String eventType, AliasAndFilter aliasAndFilter) {
        Vector<AliasAndFilter> list = this.filterMapping.get(eventType);
        if (list == null) {
            list = new Vector();
            this.filterMapping.put(eventType, list);
        }
        list.add(aliasAndFilter);
    }

    private void addConsumerToChannel(EventConsumer c) {
        String eventRouteType = c.getTargetType();
        Vector<Channel> channels = this.channelMap.get(eventRouteType);
        if (channels == null) {
            channels = new Vector();
            this.channelMap.put(eventRouteType, channels);
        }
        Channel targetChannel = null;
        for (Channel channel : channels) {
            if (!channel.getChannelType().equals((Object)c.getChannelType())) continue;
            targetChannel = channel;
            break;
        }
        if (targetChannel == null) {
            targetChannel = this.creteChannel(c.getChannelType());
            channels.add(targetChannel);
        }
        targetChannel.addConsumer(c);
    }

    private Channel creteChannel(Channel.ChannelType channelType) {
        return ChannelFactory.createChannel(channelType);
    }

    @Override
    public void sendEvent(Event e) {
        Boolean isAliasType = this.eventTypesMap.get(e.getType());
        if (isAliasType == null) {
            throw new RuntimeException("The event type not regist:" + e.getType());
        }
        if (isAliasType.booleanValue()) {
            throw new RuntimeException("The event type not regist:" + e.getType() + " It's a alias type");
        }
        this.executeOnChannel(e.getType(), e);
        Vector<AliasAndFilter> list = this.filterMapping.get(e.getType());
        if (list != null) {
            for (AliasAndFilter aaf : list) {
                if (!aaf.filter.match(e)) continue;
                this.executeOnChannel(aaf.alias, e);
            }
        }
    }

    private void executeOnChannel(String routeTpe, Event e) {
        Vector<Channel> channel = this.channelMap.get(routeTpe);
        if (channel == null) {
            return;
        }
        for (Channel c : channel) {
            c.sendEvent(e);
        }
    }

    @Override
    public Channel.ChannelType getChannelType() {
        throw new RuntimeException("Can't call this method on ChnnelFacade");
    }

    static class AliasAndFilter {
        String alias;
        IEventFilter filter;

        AliasAndFilter(String a, IEventFilter f) {
            this.alias = a;
            this.filter = f;
        }
    }
}

