/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.spands;

import java.sql.JDBCType;
import java.util.Stack;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.core.das.spands.EmptyExpressionEvaluator;
import net.jplugin.core.das.spands.EvaluatContext;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.ValueListExpression;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;

public class ExpressionEvaluator
extends EmptyExpressionEvaluator {
    Stack<Value> valueStack;

    public static Value evaluate(EvaluatContext ctx, Expression exp) {
        ExpressionEvaluator ee = new ExpressionEvaluator();
        exp.accept((ExpressionVisitor)ee);
        AssertKit.assertEqual(ee.valueStack.size(), 1);
        return ee.valueStack.pop();
    }

    @Override
    public void visit(NullValue nullValue) {
        this.valueStack.push(Value.with(JDBCType.NULL, null));
    }

    @Override
    public void visit(LongValue longValue) {
        this.valueStack.push(Value.with(JDBCType.NUMERIC, longValue.getValue()));
    }

    @Override
    public void visit(DateValue dateValue) {
        this.valueStack.push(Value.with(JDBCType.DATE, dateValue.getValue()));
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.valueStack.push(Value.with(JDBCType.TIME, timeValue.getValue()));
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.valueStack.push(Value.with(JDBCType.TIMESTAMP, timestampValue.getValue()));
    }

    @Override
    public void visit(StringValue stringValue) {
        this.valueStack.push(Value.with(JDBCType.CHAR, stringValue.getValue()));
    }

    @Override
    public void visit(Addition addition) {
        addition.getLeftExpression().accept((ExpressionVisitor)this);
        addition.getRightExpression().accept((ExpressionVisitor)this);
        Value vr = this.valueStack.pop();
        Value vl = this.valueStack.pop();
        this.valueStack.push(this.add(vl, vr));
    }

    private Value add(Value vl, Value vr) {
        return null;
    }

    @Override
    public void visit(Division division) {
        super.visit(division);
    }

    @Override
    public void visit(Subtraction subtraction) {
        super.visit(subtraction);
    }

    @Override
    public void visit(AndExpression andExpression) {
        super.visit(andExpression);
    }

    @Override
    public void visit(OrExpression orExpression) {
        super.visit(orExpression);
    }

    @Override
    public void visit(Between between) {
        super.visit(between);
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        super.visit(equalsTo);
    }

    @Override
    public void visit(InExpression inExpression) {
        super.visit(inExpression);
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        super.visit(notEqualsTo);
    }

    @Override
    public void visit(Column tableColumn) {
        super.visit(tableColumn);
    }

    @Override
    public void visit(CastExpression cast) {
        super.visit(cast);
    }

    @Override
    public void visit(ValueListExpression valueList) {
        super.visit(valueList);
    }

    @Override
    public void visit(NotExpression aThis) {
        super.visit(aThis);
    }

    public static class Value {
        JDBCType type;
        Object val;

        public JDBCType getType() {
            return this.type;
        }

        public Object getVal() {
            return this.val;
        }

        public static Value with(JDBCType t, Object v) {
            Value o = new Value();
            o.type = t;
            o.val = v;
            return o;
        }
    }
}

