/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import net.jplugin.core.das.route.impl.util.Transformer;

public class SqlTypeKit {
    public static Transformer<Object> service = new CommonTransformer();
    private static Map<Class, Transformer> transformers = new HashMap<Class, Transformer>();
    private static NullTransformer nullTransformer = new NullTransformer();
    private static Map<Integer, Class> jdbcTypeToJavaType = new HashMap<Integer, Class>();

    public static <T> T get(Object obj, Class<T> c) throws SQLException {
        if (obj == null) {
            return null;
        }
        Transformer t = transformers.get(obj.getClass());
        if (t == null) {
            throw new SQLException("can't find transformer for type:" + obj.getClass());
        }
        if (c == String.class) {
            return (T)t.getString(obj);
        }
        if (c == Boolean.class) {
            return (T)t.getBoolean(obj);
        }
        if (c == Byte.class || c == Byte.TYPE) {
            return (T)t.getByte(obj);
        }
        if (c == Short.class || c == Short.TYPE) {
            return (T)t.getShort(obj);
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return (T)t.getInt(obj);
        }
        if (c == Long.class || c == Long.TYPE) {
            return (T)t.getLong(obj);
        }
        if (c == Float.class || c == Float.TYPE) {
            return (T)t.getFloat(obj);
        }
        if (c == Double.class || c == Double.TYPE) {
            return (T)t.getDouble(obj);
        }
        if (c == BigDecimal.class) {
            return (T)t.getBigDecimal(obj);
        }
        if (c == byte[].class) {
            return (T)t.getBytes(obj);
        }
        if (c == Date.class) {
            return (T)t.getDate(obj);
        }
        if (c == Time.class) {
            return (T)t.getTime(obj);
        }
        if (c == Timestamp.class) {
            return (T)t.getTimestamp(obj);
        }
        if (c == InputStream.class) {
            return (T)t.getAsciiStream(obj);
        }
        throw new SQLException("not supported class:" + c.getName());
    }

    static {
        transformers.put(Timestamp.class, new FromTimestampTransformer());
        transformers.put(Date.class, new FromDateTransformer());
        transformers.put(Time.class, new FromTimeTransformer());
        transformers.put(Time.class, new FromTimeTransformer());
        transformers.put(byte[].class, new FromBytesTransformer());
        transformers.put(Double.TYPE, new FromDoubleTransformer());
        transformers.put(Double.class, new FromDoubleTransformer());
        transformers.put(Float.class, new FromFloatTransformer());
        transformers.put(Float.TYPE, new FromFloatTransformer());
        transformers.put(Long.TYPE, new FromLongTransformer());
        transformers.put(Long.class, new FromLongTransformer());
        transformers.put(Integer.TYPE, new FromIntTransformer());
        transformers.put(Integer.class, new FromIntTransformer());
        transformers.put(Short.TYPE, new FromShortTransformer());
        transformers.put(Short.class, new FromShortTransformer());
        transformers.put(Byte.TYPE, new FromByteTransformer());
        transformers.put(Byte.class, new FromByteTransformer());
        transformers.put(Boolean.class, new FromBooleanTransformer());
        transformers.put(Boolean.TYPE, new FromBooleanTransformer());
        transformers.put(String.class, new FromStringTransformer());
        transformers.put(BigDecimal.class, new FromBigDecimalTransformer());
    }

    private static class NullTransformer
    implements Transformer {
        private NullTransformer() {
        }

        public String getString(Object o) throws SQLException {
            return null;
        }

        public Boolean getBoolean(Object o) throws SQLException {
            return null;
        }

        public Byte getByte(Object o) throws SQLException {
            return null;
        }

        public Short getShort(Object o) throws SQLException {
            return null;
        }

        public Integer getInt(Object o) throws SQLException {
            return null;
        }

        public Long getLong(Object o) throws SQLException {
            return null;
        }

        public Float getFloat(Object o) throws SQLException {
            return null;
        }

        public Double getDouble(Object o) throws SQLException {
            return null;
        }

        public BigDecimal getBigDecimal(Object o) throws SQLException {
            return null;
        }

        public byte[] getBytes(Object o) throws SQLException {
            return null;
        }

        public Date getDate(Object o) throws SQLException {
            return null;
        }

        public Time getTime(Object o) throws SQLException {
            return null;
        }

        public Timestamp getTimestamp(Object o) throws SQLException {
            return null;
        }

        public InputStream getAsciiStream(Object o) throws SQLException {
            return null;
        }

        public InputStream getUnicodeStream(Object o) throws SQLException {
            return null;
        }

        public InputStream getBinaryStream(Object o) throws SQLException {
            return null;
        }
    }

    private static abstract class BasicNumicaTransformer<T extends Number>
    implements Transformer<T> {
        private BasicNumicaTransformer() {
        }

        @Override
        public final String getString(T o) throws SQLException {
            return o.toString();
        }

        @Override
        public final Boolean getBoolean(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final byte[] getBytes(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final Date getDate(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final Time getTime(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final Timestamp getTimestamp(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final InputStream getAsciiStream(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final InputStream getUnicodeStream(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final InputStream getBinaryStream(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final Byte getByte(T o) throws SQLException {
            return ((Number)o).byteValue();
        }

        @Override
        public final Short getShort(T o) throws SQLException {
            return ((Number)o).shortValue();
        }

        @Override
        public final Integer getInt(T o) throws SQLException {
            return ((Number)o).intValue();
        }

        @Override
        public final Long getLong(T o) throws SQLException {
            return ((Number)o).longValue();
        }

        @Override
        public final Float getFloat(T o) throws SQLException {
            return Float.valueOf(((Number)o).floatValue());
        }

        @Override
        public final Double getDouble(T o) throws SQLException {
            return ((Number)o).doubleValue();
        }
    }

    private static abstract class BasicTimeTransformer<T>
    implements Transformer<T> {
        private BasicTimeTransformer() {
        }

        @Override
        public final String getString(T o) throws SQLException {
            return o.toString();
        }

        @Override
        public final Boolean getBoolean(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final Byte getByte(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final Short getShort(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final Integer getInt(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final Long getLong(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final Float getFloat(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final Double getDouble(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final BigDecimal getBigDecimal(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final byte[] getBytes(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final InputStream getAsciiStream(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final InputStream getUnicodeStream(T o) throws SQLException {
            throw new SQLException("not support");
        }

        @Override
        public final InputStream getBinaryStream(T o) throws SQLException {
            throw new SQLException("not support");
        }
    }

    private static class FromStringTransformer
    implements Transformer<String> {
        private FromStringTransformer() {
        }

        @Override
        public String getString(String o) throws SQLException {
            return o;
        }

        @Override
        public Boolean getBoolean(String o) throws SQLException {
            return "true".equalsIgnoreCase(o);
        }

        @Override
        public Byte getByte(String o) throws SQLException {
            throw new SQLException("not support transformer ." + o);
        }

        @Override
        public Short getShort(String o) throws SQLException {
            return Short.parseShort(o);
        }

        @Override
        public Integer getInt(String o) throws SQLException {
            return Integer.parseInt(o);
        }

        @Override
        public Long getLong(String o) throws SQLException {
            return Long.parseLong(o);
        }

        @Override
        public Float getFloat(String o) throws SQLException {
            return Float.valueOf(Float.parseFloat(o));
        }

        @Override
        public Double getDouble(String o) throws SQLException {
            return Double.parseDouble(o);
        }

        @Override
        public BigDecimal getBigDecimal(String o) throws SQLException {
            return BigDecimal.valueOf(Double.parseDouble(o));
        }

        @Override
        public byte[] getBytes(String o) throws SQLException {
            return o.getBytes();
        }

        @Override
        public Date getDate(String o) throws SQLException {
            throw new SQLException("not support transformer ." + o);
        }

        @Override
        public Time getTime(String o) throws SQLException {
            throw new SQLException("not support transformer ." + o);
        }

        @Override
        public Timestamp getTimestamp(String o) throws SQLException {
            throw new SQLException("not support transformer ." + o);
        }

        @Override
        public InputStream getAsciiStream(String o) throws SQLException {
            try {
                return new ByteArrayInputStream(o.getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e);
            }
        }

        @Override
        public InputStream getUnicodeStream(String o) throws SQLException {
            try {
                return new ByteArrayInputStream(o.getBytes("UTF-16"));
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e);
            }
        }

        @Override
        public InputStream getBinaryStream(String o) throws SQLException {
            return new ByteArrayInputStream(o.getBytes());
        }
    }

    private static class FromBooleanTransformer
    implements Transformer<Boolean> {
        private FromBooleanTransformer() {
        }

        @Override
        public String getString(Boolean o) throws SQLException {
            return o.toString();
        }

        @Override
        public Boolean getBoolean(Boolean o) throws SQLException {
            return o;
        }

        @Override
        public Byte getByte(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public Short getShort(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public Integer getInt(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public Long getLong(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public Float getFloat(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public Double getDouble(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public BigDecimal getBigDecimal(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public byte[] getBytes(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public Date getDate(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public Time getTime(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public Timestamp getTimestamp(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public InputStream getAsciiStream(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public InputStream getUnicodeStream(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }

        @Override
        public InputStream getBinaryStream(Boolean o) throws SQLException {
            throw new SQLException("not support.");
        }
    }

    static class FromShortTransformer
    extends BasicNumicaTransformer<Byte> {
        FromShortTransformer() {
        }

        @Override
        public BigDecimal getBigDecimal(Byte o) throws SQLException {
            return new BigDecimal(o.byteValue());
        }
    }

    static class FromByteTransformer
    extends BasicNumicaTransformer<Byte> {
        FromByteTransformer() {
        }

        @Override
        public BigDecimal getBigDecimal(Byte o) throws SQLException {
            return new BigDecimal(o.byteValue());
        }
    }

    static class FromIntTransformer
    extends BasicNumicaTransformer<Integer> {
        FromIntTransformer() {
        }

        @Override
        public BigDecimal getBigDecimal(Integer o) throws SQLException {
            return new BigDecimal(o);
        }
    }

    private static class FromLongTransformer
    extends BasicNumicaTransformer<Long> {
        private FromLongTransformer() {
        }

        @Override
        public BigDecimal getBigDecimal(Long o) throws SQLException {
            return new BigDecimal(o);
        }
    }

    private static class FromFloatTransformer
    extends BasicNumicaTransformer<Float> {
        private FromFloatTransformer() {
        }

        @Override
        public BigDecimal getBigDecimal(Float o) throws SQLException {
            return new BigDecimal(o.floatValue());
        }
    }

    private static class FromDoubleTransformer
    extends BasicNumicaTransformer<Double> {
        private FromDoubleTransformer() {
        }

        @Override
        public BigDecimal getBigDecimal(Double o) throws SQLException {
            return new BigDecimal(o);
        }
    }

    private static class FromBigDecimalTransformer
    extends BasicNumicaTransformer<BigDecimal> {
        private FromBigDecimalTransformer() {
        }

        @Override
        public BigDecimal getBigDecimal(BigDecimal o) throws SQLException {
            return o;
        }
    }

    private static class FromBytesTransformer
    implements Transformer<byte[]> {
        private FromBytesTransformer() {
        }

        @Override
        public String getString(byte[] o) throws SQLException {
            return new String(o);
        }

        @Override
        public Boolean getBoolean(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public Byte getByte(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public Short getShort(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public Integer getInt(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public Long getLong(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public Float getFloat(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public Double getDouble(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public BigDecimal getBigDecimal(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public byte[] getBytes(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public Date getDate(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public Time getTime(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public Timestamp getTimestamp(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public InputStream getAsciiStream(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public InputStream getUnicodeStream(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public InputStream getBinaryStream(byte[] o) throws SQLException {
            throw new RuntimeException("not support");
        }
    }

    private static class FromDateTransformer
    extends BasicTimeTransformer<Date> {
        private FromDateTransformer() {
        }

        @Override
        public Date getDate(Date o) throws SQLException {
            return o;
        }

        @Override
        public Time getTime(Date o) throws SQLException {
            return new Time(o.getTime());
        }

        @Override
        public Timestamp getTimestamp(Date o) throws SQLException {
            return new Timestamp(o.getTime());
        }
    }

    private static class FromTimeTransformer
    extends BasicTimeTransformer<Time> {
        private FromTimeTransformer() {
        }

        @Override
        public Date getDate(Time o) throws SQLException {
            throw new RuntimeException("not support");
        }

        @Override
        public Time getTime(Time o) throws SQLException {
            return o;
        }

        @Override
        public Timestamp getTimestamp(Time o) throws SQLException {
            throw new RuntimeException("not support");
        }
    }

    private static class FromTimestampTransformer
    extends BasicTimeTransformer<Timestamp> {
        private FromTimestampTransformer() {
        }

        @Override
        public Date getDate(Timestamp o) throws SQLException {
            return new Date(o.getTime());
        }

        @Override
        public Time getTime(Timestamp o) throws SQLException {
            return new Time(o.getTime());
        }

        @Override
        public Timestamp getTimestamp(Timestamp o) throws SQLException {
            return o;
        }
    }

    public static class CommonTransformer
    implements Transformer<Object> {
        Transformer get(Object o) throws SQLException {
            if (o == null) {
                return nullTransformer;
            }
            Transformer t = (Transformer)transformers.get(o.getClass());
            if (t == null) {
                throw new SQLException("can't find transformer for type:" + o.getClass());
            }
            return t;
        }

        @Override
        public String getString(Object o) throws SQLException {
            return this.get(o).getString(o);
        }

        @Override
        public Boolean getBoolean(Object o) throws SQLException {
            return this.get(o).getBoolean(o);
        }

        @Override
        public Byte getByte(Object o) throws SQLException {
            return this.get(o).getByte(o);
        }

        @Override
        public Short getShort(Object o) throws SQLException {
            return this.get(o).getShort(o);
        }

        @Override
        public Integer getInt(Object o) throws SQLException {
            return this.get(o).getInt(o);
        }

        @Override
        public Long getLong(Object o) throws SQLException {
            return this.get(o).getLong(o);
        }

        @Override
        public Float getFloat(Object o) throws SQLException {
            return this.get(o).getFloat(o);
        }

        @Override
        public Double getDouble(Object o) throws SQLException {
            return this.get(o).getDouble(o);
        }

        @Override
        public BigDecimal getBigDecimal(Object o) throws SQLException {
            return this.get(o).getBigDecimal(o);
        }

        @Override
        public byte[] getBytes(Object o) throws SQLException {
            return this.get(o).getBytes(o);
        }

        @Override
        public Date getDate(Object o) throws SQLException {
            return this.get(o).getDate(o);
        }

        @Override
        public Time getTime(Object o) throws SQLException {
            return this.get(o).getTime(o);
        }

        @Override
        public Timestamp getTimestamp(Object o) throws SQLException {
            return this.get(o).getTimestamp(o);
        }

        @Override
        public InputStream getAsciiStream(Object o) throws SQLException {
            return this.get(o).getAsciiStream(o);
        }

        @Override
        public InputStream getUnicodeStream(Object o) throws SQLException {
            return this.get(o).getUnicodeStream(o);
        }

        @Override
        public InputStream getBinaryStream(Object o) throws SQLException {
            return this.get(o).getBinaryStream(o);
        }
    }
}

