/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.sqlhandler2;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.core.das.route.api.RouterKeyFilter;
import net.jplugin.core.das.route.impl.util.FunctionEvalueKit;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.CollateExpression;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.NextValExpression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.ValueListExpression;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SubSelect;

public class VisitorForAndExpression
implements ExpressionVisitor {
    private String keyColumnName;
    private List<Object> parameters;
    Object left = null;
    Object right = null;
    Object eq = null;
    List<Object> inList = null;
    List<Expression> otherIntersectExpressions = null;

    public VisitorForAndExpression(String keyColName, List<Object> aParameters) {
        this.keyColumnName = keyColName;
        this.parameters = aParameters;
    }

    public RouterKeyFilter getKnownFilter() {
        if (this.eq != null) {
            return new RouterKeyFilter(RouterKeyFilter.Operator.EQUAL, new Object[]{this.eq});
        }
        if (this.inList != null && !this.inList.isEmpty()) {
            return new RouterKeyFilter(RouterKeyFilter.Operator.IN, this.inList.toArray(new Object[this.inList.size()]));
        }
        if (this.left != null || this.right != null) {
            return new RouterKeyFilter(RouterKeyFilter.Operator.BETWEEN, new Object[]{this.left, this.right});
        }
        return null;
    }

    public List<Expression> getOtherIntersectExpressions() {
        return this.otherIntersectExpressions;
    }

    public void clear() {
        this.left = null;
        this.right = null;
        this.eq = null;
        this.inList = null;
    }

    public void visit(AndExpression andExpression) {
        andExpression.getLeftExpression().accept((ExpressionVisitor)this);
        andExpression.getRightExpression().accept((ExpressionVisitor)this);
    }

    public void visit(OrExpression orExpression) {
        if (this.otherIntersectExpressions == null) {
            this.otherIntersectExpressions = new ArrayList<Expression>();
        }
        this.otherIntersectExpressions.add((Expression)orExpression);
    }

    public void visit(Parenthesis parenthesis) {
        parenthesis.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(Between e) {
        this.checkAndAddLeft(e.getLeftExpression(), e.getBetweenExpressionStart());
        this.checkAndAddRight(e.getLeftExpression(), e.getBetweenExpressionEnd());
    }

    public void visit(EqualsTo e) {
        this.checkAndAddEQ(e.getLeftExpression(), e.getRightExpression());
    }

    public void visit(GreaterThan e) {
        this.checkAndAddLeft(e.getLeftExpression(), e.getRightExpression());
    }

    public void visit(GreaterThanEquals e) {
        this.checkAndAddLeft(e.getLeftExpression(), e.getRightExpression());
    }

    public void visit(InExpression e) {
        this.checkAndAddIn(e.getLeftExpression(), e.getRightItemsList());
    }

    public void visit(MinorThan e) {
        this.checkAndAddRight(e.getLeftExpression(), e.getRightExpression());
    }

    public void visit(MinorThanEquals e) {
        this.checkAndAddRight(e.getLeftExpression(), e.getRightExpression());
    }

    public void visit(Function function) {
    }

    private void checkAndAddIn(Expression leftExpression, ItemsList rightItemsList) {
        if (this.inList != null) {
            return;
        }
        if (this.checkLeftColunn(leftExpression) && rightItemsList instanceof ExpressionList) {
            List expressions = ((ExpressionList)rightItemsList).getExpressions();
            ArrayList<Object> values = new ArrayList<Object>();
            for (Expression item : expressions) {
                Object v = this.tryComputeValue(item);
                if (v != null) {
                    values.add(v);
                    continue;
                }
                return;
            }
            this.inList = values;
        }
    }

    private Object tryComputeValue(Expression item) {
        return FunctionEvalueKit.evalueNonStrickly(item, this.parameters);
    }

    private boolean checkLeftColunn(Expression leftExpression) {
        if (!(leftExpression instanceof Column)) {
            return false;
        }
        String name = ((Column)leftExpression).getColumnName();
        return this.keyColumnName.equals(name);
    }

    private void checkAndAddRight(Expression leftExpression, Expression rightExpression) {
        Object v;
        if (this.right != null) {
            return;
        }
        if (this.checkLeftColunn(leftExpression) && (v = this.tryComputeValue(rightExpression)) != null) {
            this.right = v;
        }
    }

    private void checkAndAddEQ(Expression leftExpression, Expression rightExpression) {
        Object v;
        if (this.eq != null) {
            return;
        }
        if (this.checkLeftColunn(leftExpression) && (v = this.tryComputeValue(rightExpression)) != null) {
            this.eq = v;
        }
    }

    private void checkAndAddLeft(Expression leftExpression, Expression rightExpression) {
        Object v;
        if (this.left != null) {
            return;
        }
        if (this.checkLeftColunn(leftExpression) && (v = this.tryComputeValue(rightExpression)) != null) {
            this.left = v;
        }
    }

    public void visit(NullValue nullValue) {
    }

    public void visit(SignedExpression signedExpression) {
    }

    public void visit(JdbcParameter jdbcParameter) {
    }

    public void visit(JdbcNamedParameter jdbcNamedParameter) {
    }

    public void visit(DoubleValue doubleValue) {
    }

    public void visit(LongValue longValue) {
    }

    public void visit(HexValue hexValue) {
    }

    public void visit(DateValue dateValue) {
    }

    public void visit(TimeValue timeValue) {
    }

    public void visit(TimestampValue timestampValue) {
    }

    public void visit(StringValue stringValue) {
    }

    public void visit(Addition addition) {
    }

    public void visit(Division division) {
    }

    public void visit(Multiplication multiplication) {
    }

    public void visit(Subtraction subtraction) {
    }

    public void visit(IsNullExpression isNullExpression) {
    }

    public void visit(LikeExpression likeExpression) {
    }

    public void visit(NotEqualsTo notEqualsTo) {
    }

    public void visit(Column tableColumn) {
    }

    public void visit(SubSelect subSelect) {
    }

    public void visit(CaseExpression caseExpression) {
    }

    public void visit(WhenClause whenClause) {
    }

    public void visit(ExistsExpression existsExpression) {
    }

    public void visit(AllComparisonExpression allComparisonExpression) {
    }

    public void visit(AnyComparisonExpression anyComparisonExpression) {
    }

    public void visit(Concat concat) {
    }

    public void visit(Matches matches) {
    }

    public void visit(BitwiseAnd bitwiseAnd) {
    }

    public void visit(BitwiseOr bitwiseOr) {
    }

    public void visit(BitwiseXor bitwiseXor) {
    }

    public void visit(CastExpression cast) {
    }

    public void visit(Modulo modulo) {
    }

    public void visit(AnalyticExpression aexpr) {
    }

    public void visit(ExtractExpression eexpr) {
    }

    public void visit(IntervalExpression iexpr) {
    }

    public void visit(OracleHierarchicalExpression oexpr) {
    }

    public void visit(RegExpMatchOperator rexpr) {
    }

    public void visit(JsonExpression jsonExpr) {
    }

    public void visit(JsonOperator jsonExpr) {
    }

    public void visit(RegExpMySQLOperator regExpMySQLOperator) {
    }

    public void visit(UserVariable var) {
    }

    public void visit(NumericBind bind) {
    }

    public void visit(KeepExpression aexpr) {
    }

    public void visit(MySQLGroupConcat groupConcat) {
    }

    public void visit(RowConstructor rowConstructor) {
    }

    public void visit(OracleHint hint) {
    }

    public void visit(TimeKeyExpression timeKeyExpression) {
    }

    public void visit(DateTimeLiteralExpression literal) {
    }

    public void visit(NotExpression aThis) {
        aThis.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(BitwiseRightShift aThis) {
    }

    public void visit(BitwiseLeftShift aThis) {
    }

    public void visit(ValueListExpression valueList) {
    }

    public void visit(NextValExpression aThis) {
    }

    public void visit(CollateExpression aThis) {
    }

    public void visit(SimilarToExpression aThis) {
    }
}

