/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.sqlhandler2;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.core.das.route.api.RouterKeyFilter;
import net.jplugin.core.das.route.impl.sqlhandler2.VisitorForAndExpression;
import net.jplugin.core.das.route.impl.sqlhandler2.VisitorForOrExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;

public class VisitorExpressionManager {
    public static List<RouterKeyFilter> getKeyFilterList(Expression where, String fieldName, List<Object> parameters) {
        VisitorForAndExpression andVisitor = new VisitorForAndExpression(fieldName, parameters);
        where.accept((ExpressionVisitor)andVisitor);
        RouterKeyFilter knownFilter = andVisitor.getKnownFilter();
        if (knownFilter != null) {
            ArrayList<RouterKeyFilter> list = new ArrayList<RouterKeyFilter>(1);
            list.add(knownFilter);
            return list;
        }
        List<Expression> intersectExpList = andVisitor.getOtherIntersectExpressions();
        if (intersectExpList == null || intersectExpList.isEmpty()) {
            return null;
        }
        ArrayList<List<RouterKeyFilter>> resultsToInsect = new ArrayList<List<RouterKeyFilter>>(intersectExpList.size());
        VisitorForOrExpression orVisitor = new VisitorForOrExpression();
        for (Expression exp : intersectExpList) {
            orVisitor.clear();
            List<RouterKeyFilter> list = VisitorExpressionManager.getResultToIntersect(andVisitor, orVisitor, exp);
            resultsToInsect.add(list);
        }
        ArrayList<RouterKeyFilter> resultFilters = new ArrayList<RouterKeyFilter>(resultsToInsect.size());
        for (List list : resultsToInsect) {
            RouterKeyFilter filter = VisitorExpressionManager.getUnionFilter(list);
            if (filter == null) continue;
            resultFilters.add(filter);
        }
        if (resultFilters.size() == 0) {
            return null;
        }
        return resultFilters;
    }

    private static List<RouterKeyFilter> getResultToIntersect(VisitorForAndExpression andVisitor, VisitorForOrExpression orVisitor, Expression exp) {
        orVisitor.travelUnionExpressions(exp);
        List<Expression> unionExpressions = orVisitor.get();
        ArrayList<RouterKeyFilter> result = new ArrayList<RouterKeyFilter>(unionExpressions.size());
        for (Expression uExp : unionExpressions) {
            andVisitor.clear();
            uExp.accept((ExpressionVisitor)andVisitor);
            result.add(andVisitor.getKnownFilter());
        }
        return result;
    }

    private static RouterKeyFilter getUnionFilter(List<RouterKeyFilter> list) {
        AssertKit.assertTrue(list.size() > 1);
        ArrayList<Object> values = new ArrayList<Object>();
        for (RouterKeyFilter kf : list) {
            if (kf == null || kf.getOperator() == RouterKeyFilter.Operator.ALL || kf.getOperator() == RouterKeyFilter.Operator.BETWEEN) {
                return null;
            }
            if (kf.getOperator() != RouterKeyFilter.Operator.EQUAL && kf.getOperator() != RouterKeyFilter.Operator.IN) continue;
            for (Object v : kf.getConstValue()) {
                values.add(v);
            }
        }
        return new RouterKeyFilter(RouterKeyFilter.Operator.IN, values.toArray(new Object[values.size()]));
    }
}

