/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.sqlhandler2;

import java.util.List;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.CollateExpression;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.NextValExpression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.ValueListExpression;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;

public class TableNameReplacerKit {
    public static void handleDelete(Delete stmt, String toTableName) {
        Table tb = stmt.getTable();
        String fromTableName = tb.getName();
        tb.setName(toTableName);
        Alias alais = tb.getAlias();
        if (alais != null && StringKit.isNotNull(alais.getName())) {
            return;
        }
        ChangeWhereClauseTableNameVisitor visitor = new ChangeWhereClauseTableNameVisitor();
        visitor.handle(stmt.getWhere(), fromTableName, toTableName);
    }

    public static void handleUpdate(Update stmt, String toTableName) {
        Table tb = (Table)stmt.getTables().get(0);
        String fromTableName = tb.getName();
        tb.setName(toTableName);
        Alias alais = tb.getAlias();
        if (alais != null && StringKit.isNotNull(alais.getName())) {
            return;
        }
        ChangeWhereClauseTableNameVisitor visitor = new ChangeWhereClauseTableNameVisitor();
        visitor.handle(stmt.getWhere(), fromTableName, toTableName);
    }

    public static void handleSelect(PlainSelect ps, String toTableName) {
        Table tb = (Table)ps.getFromItem();
        String fromTableName = tb.getName();
        tb.setName(toTableName);
        Alias alais = tb.getAlias();
        if (alais != null && StringKit.isNotNull(alais.getName())) {
            return;
        }
        ChangeWhereClauseTableNameVisitor visitor = new ChangeWhereClauseTableNameVisitor();
        visitor.handle(ps.getWhere(), fromTableName, toTableName);
    }

    static class ChangeWhereClauseTableNameVisitor
    implements ExpressionVisitor,
    ItemsListVisitor {
        private String fromTableName;
        private String toTableName;

        ChangeWhereClauseTableNameVisitor() {
        }

        public void handle(Expression exp, String fname, String tname) {
            this.fromTableName = fname;
            this.toTableName = tname;
            if (exp != null) {
                exp.accept((ExpressionVisitor)this);
            }
        }

        public void visit(Column tableColumn) {
            Table tb = tableColumn.getTable();
            if (tb != null && this.fromTableName.equalsIgnoreCase(tb.getName())) {
                tb.setName(this.toTableName);
            }
        }

        public void visit(BitwiseRightShift aThis) {
            this.visitExpressions(aThis.getLeftExpression(), aThis.getRightExpression());
        }

        public void visit(BitwiseLeftShift aThis) {
            this.visitExpressions(aThis.getLeftExpression(), aThis.getRightExpression());
        }

        public void visit(NullValue nullValue) {
        }

        public void visit(Function function) {
            List exps;
            NamedExpressionList np;
            List exps2;
            ExpressionList paras = function.getParameters();
            if (paras != null && (exps2 = paras.getExpressions()) != null) {
                for (Expression exp : exps2) {
                    exp.accept((ExpressionVisitor)this);
                }
            }
            if ((np = function.getNamedParameters()) != null && np.getExpressions() != null && (exps = np.getExpressions()) != null) {
                for (Expression exp : exps) {
                    exp.accept((ExpressionVisitor)this);
                }
            }
        }

        public void visit(SignedExpression signedExpression) {
            signedExpression.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(JdbcParameter jdbcParameter) {
        }

        public void visit(JdbcNamedParameter jdbcNamedParameter) {
        }

        public void visit(DoubleValue doubleValue) {
        }

        public void visit(LongValue longValue) {
        }

        public void visit(HexValue hexValue) {
        }

        public void visit(DateValue dateValue) {
        }

        public void visit(TimeValue timeValue) {
        }

        public void visit(TimestampValue timestampValue) {
        }

        public void visit(Parenthesis parenthesis) {
        }

        public void visit(StringValue stringValue) {
        }

        public void visit(Addition addition) {
            this.visitExpressions(addition.getLeftExpression(), addition.getRightExpression());
        }

        void visitExpressions(Expression ... exps) {
            for (Expression exp : exps) {
                if (exp == null) continue;
                exp.accept((ExpressionVisitor)this);
            }
        }

        public void visit(Division ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(Multiplication ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(Subtraction ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(AndExpression ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(OrExpression ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(Between ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getBetweenExpressionStart(), ex.getBetweenExpressionEnd());
        }

        public void visit(EqualsTo ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(GreaterThan ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(GreaterThanEquals ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(InExpression ex) {
            this.visitExpressions(ex.getLeftExpression());
            ItemsList items = ex.getRightItemsList();
            if (items != null) {
                items.accept((ItemsListVisitor)this);
            }
        }

        public void visit(IsNullExpression ex) {
            this.visitExpressions(ex.getLeftExpression());
        }

        public void visit(LikeExpression ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(MinorThan ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(MinorThanEquals ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(NotEqualsTo ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(SubSelect subSelect) {
            SelectBody body = subSelect.getSelectBody();
            if (!(body instanceof PlainSelect)) {
                throw new TablesplitException("not support." + body.getClass().getName());
            }
            ((PlainSelect)body).getWhere().accept((ExpressionVisitor)this);
        }

        public void visit(CaseExpression ex) {
            this.visitExpressions(ex.getSwitchExpression(), ex.getElseExpression());
            List wcs = ex.getWhenClauses();
            if (wcs != null && wcs.size() > 0) {
                for (WhenClause wc : wcs) {
                    wc.accept((ExpressionVisitor)this);
                }
            }
        }

        public void visit(WhenClause wc) {
            this.visitExpressions(wc.getWhenExpression(), wc.getThenExpression());
        }

        public void visit(ExistsExpression ex) {
            this.visitExpressions(ex.getRightExpression());
        }

        public void visit(AllComparisonExpression ex) {
            SubSelect ss = ex.getSubSelect();
            if (ss == null) {
                return;
            }
            SelectBody body = ss.getSelectBody();
            if (!(body instanceof PlainSelect)) {
                throw new TablesplitException("not support." + body.getClass().getName());
            }
            ((PlainSelect)body).getWhere().accept((ExpressionVisitor)this);
        }

        public void visit(AnyComparisonExpression anyComparisonExpression) {
            SubSelect ss = anyComparisonExpression.getSubSelect();
            if (ss == null) {
                return;
            }
            SelectBody body = ss.getSelectBody();
            if (!(body instanceof PlainSelect)) {
                throw new TablesplitException("not support." + body.getClass().getName());
            }
            ((PlainSelect)body).getWhere().accept((ExpressionVisitor)this);
        }

        public void visit(Concat concat) {
            this.visitExpressions(concat.getLeftExpression(), concat.getRightExpression());
        }

        public void visit(Matches ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(BitwiseAnd ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(BitwiseOr ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(BitwiseXor ex) {
            this.visitExpressions(ex.getLeftExpression(), ex.getRightExpression());
        }

        public void visit(CastExpression cast) {
            cast.getLeftExpression().accept((ExpressionVisitor)this);
        }

        public void visit(Modulo modulo) {
        }

        public void visit(AnalyticExpression aexpr) {
            throw new TablesplitException("not support");
        }

        public void visit(ExtractExpression eexpr) {
            eexpr.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(IntervalExpression iexpr) {
        }

        public void visit(OracleHierarchicalExpression oexpr) {
        }

        public void visit(RegExpMatchOperator rexpr) {
        }

        public void visit(JsonExpression jsonExpr) {
        }

        public void visit(JsonOperator jsonExpr) {
        }

        public void visit(RegExpMySQLOperator regExpMySQLOperator) {
        }

        public void visit(UserVariable var) {
        }

        public void visit(NumericBind bind) {
        }

        public void visit(KeepExpression aexpr) {
            throw new TablesplitException("not support");
        }

        public void visit(MySQLGroupConcat groupConcat) {
            throw new TablesplitException("not support");
        }

        public void visit(ValueListExpression valueList) {
            for (Expression ex : valueList.getExpressionList().getExpressions()) {
                ex.accept((ExpressionVisitor)this);
            }
        }

        public void visit(RowConstructor rowConstructor) {
        }

        public void visit(OracleHint hint) {
        }

        public void visit(TimeKeyExpression timeKeyExpression) {
        }

        public void visit(DateTimeLiteralExpression literal) {
        }

        public void visit(NotExpression aThis) {
            this.visitExpressions(aThis.getExpression());
        }

        public void visit(NextValExpression aThis) {
        }

        public void visit(CollateExpression aThis) {
            aThis.getLeftExpression().accept((ExpressionVisitor)this);
        }

        public void visit(SimilarToExpression aThis) {
            this.visitExpressions(aThis.getLeftExpression(), aThis.getRightExpression());
        }

        public void visit(ExpressionList expressionList) {
            for (Expression ex : expressionList.getExpressions()) {
                ex.accept((ExpressionVisitor)this);
            }
        }

        public void visit(NamedExpressionList namedExpressionList) {
            for (Expression ex : namedExpressionList.getExpressions()) {
                ex.accept((ExpressionVisitor)this);
            }
        }

        public void visit(MultiExpressionList multiExprList) {
            List lists = multiExprList.getExprList();
            for (ExpressionList l : lists) {
                for (Expression ex : l.getExpressions()) {
                    ex.accept((ExpressionVisitor)this);
                }
            }
        }
    }
}

