/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.sqlhandler2;

import java.util.Set;
import net.jplugin.core.das.dds.api.IRouterDataSource;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.jplugin.core.das.dds.impl.kits.SchemaCheckKit;
import net.jplugin.core.das.route.api.RouterDataSource;
import net.jplugin.core.das.route.api.RouterDataSourceConfig;
import net.sf.jsqlparser.statement.Statement;

public class SchemaCheckUtil {
    public static void checkAndRemoveSchema(IRouterDataSource routeDs, Statement stmt, String sqlToLog) {
        Set<String> schemas = SchemaCheckKit.extractAndRemoveSchema(stmt);
        if (!SchemaCheckUtil.checkSchema(schemas, routeDs)) {
            throw new TablesplitException("schema check error. " + sqlToLog);
        }
    }

    private static boolean checkSchema(Set<String> schemas, IRouterDataSource routeDs) {
        RouterDataSourceConfig dscfg = ((RouterDataSource)routeDs).getConfig();
        for (String s : schemas) {
            Set<String> allowed;
            if (!("E_M_P_T_Y".equals(s) ? !dscfg.isAllowNoSchema() : !(allowed = dscfg.getAllowedSchemas()).contains(s) && !allowed.contains("*"))) continue;
            return false;
        }
        return true;
    }
}

