/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.sqlhandler2;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.core.das.dds.api.RouterException;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.jplugin.core.das.dds.kits.SqlParserKit;
import net.jplugin.core.das.route.api.DataSourceInfo;
import net.jplugin.core.das.route.api.ITsAlgorithm;
import net.jplugin.core.das.route.api.RouterDataSource;
import net.jplugin.core.das.route.api.RouterDataSourceConfig;
import net.jplugin.core.das.route.api.RouterKeyFilter;
import net.jplugin.core.das.route.impl.TsAlgmManager;
import net.jplugin.core.das.route.impl.conn.SqlHandleResult;
import net.jplugin.core.das.route.impl.sqlhandler2.DeleteHandler2;
import net.jplugin.core.das.route.impl.sqlhandler2.InSectUtil;
import net.jplugin.core.das.route.impl.sqlhandler2.InsertHandler2;
import net.jplugin.core.das.route.impl.sqlhandler2.SchemaCheckUtil;
import net.jplugin.core.das.route.impl.sqlhandler2.SelectHandler2;
import net.jplugin.core.das.route.impl.sqlhandler2.SpanCheckKit;
import net.jplugin.core.das.route.impl.sqlhandler2.UpdateHandler2;
import net.jplugin.core.das.route.impl.sqlhandler2.VisitorExpressionManager;
import net.jplugin.core.kernel.api.RefAnnotationSupport;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.log.api.RefLogger;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;

public abstract class AbstractCommandHandler2
extends RefAnnotationSupport {
    public static final String __THE_TB_SPS_HDR__ = "__THE_TB_SPS_HDR__";
    protected Statement statement = null;
    protected String sqlString;
    protected RouterDataSource dataSource;
    protected List<Object> parameters;
    private String tableName;
    private RouterDataSourceConfig.TableConfig tableConfig;
    private SqlHandleResult.CommandType commandType;
    @RefLogger
    Logger logger;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public static AbstractCommandHandler2 create(RouterDataSource routeDs, String sql, List<Object> params) {
        AbstractCommandHandler2 instance;
        CCJSqlParserManager pm = new CCJSqlParserManager();
        Statement stmt = SqlParserKit.parse(sql);
        if (stmt instanceof Select) {
            instance = new SelectHandler2();
        } else if (stmt instanceof Update) {
            instance = new UpdateHandler2();
        } else if (stmt instanceof Insert) {
            instance = new InsertHandler2();
        } else if (stmt instanceof Delete) {
            instance = new DeleteHandler2();
        } else {
            throw new RuntimeException("not supported sql for route:" + sql);
        }
        SchemaCheckUtil.checkAndRemoveSchema(routeDs, stmt, sql);
        instance.statement = stmt;
        instance.dataSource = routeDs;
        instance.parameters = params;
        instance.sqlString = sql;
        return instance;
    }

    protected abstract List<RouterKeyFilter> getKeyFilter();

    protected abstract void temporyChangeTableNameTo(String var1);

    protected abstract SqlHandleResult.CommandType getCommandType();

    public final SqlHandleResult handle() {
        List<RouterKeyFilter> kf = this.getKeyFilter();
        return this.getHandleResult(kf);
    }

    protected final SqlHandleResult getHandleResult(List<RouterKeyFilter> kfList) {
        if (kfList == null || kfList.isEmpty()) {
            throw new RouterException("Found null KeyFilter." + this.sqlString);
        }
        RouterDataSourceConfig.TableConfig tableCfg = this.getTableCfg();
        if (tableCfg == null) {
            throw new TablesplitException("Table not configed in the router databse." + this.tableName);
        }
        RouterKeyFilter[] keyValueArr = kfList.toArray(new RouterKeyFilter[kfList.size()]);
        DataSourceInfo[] algmResults = this.getDataSourceInfosFromKeyValueArr(keyValueArr);
        if (this.logger.isInfoEnabled()) {
            if (algmResults != null) {
                for (DataSourceInfo a : algmResults) {
                    this.logger.info("\tDataSourceInfo:" + a);
                }
            } else {
                this.logger.info("\tGet Null DataSource");
            }
        }
        SqlHandleResult result = new SqlHandleResult();
        if (algmResults == null || algmResults.length == 0) {
            throw new RuntimeException("Can't find the dest table.");
        }
        if (algmResults.length == 1 && algmResults[0].getDestTbs().length == 1) {
            String finalSql = this.getFinalSql(algmResults[0].getDestTbs()[0]);
            result.setResultSql(finalSql);
        } else {
            if (this.statement instanceof Insert) {
                throw new TablesplitException("Insert cant' support span table now. " + this.sqlString);
            }
            if (this.dataSource.getConfig().isCommentRequiredForSpan() && !SpanCheckKit.isSpanTable(this.sqlString)) {
                throw new TablesplitException("table not use spantable,can't span. " + this.sqlString);
            }
            String targetSql = this.getFinalSql(__THE_TB_SPS_HDR__);
            result.setResultSql(targetSql);
        }
        result.setCommandType(this.getCommandType());
        result.setDataSourceInfos(algmResults);
        result.setSourceTable(this.tableName);
        result.setTableConfig(this.tableConfig);
        result.setStatement(this.statement);
        return result;
    }

    private DataSourceInfo[] getDataSourceInfosFromKeyValueArr(RouterKeyFilter[] keyValueArr) {
        if (keyValueArr.length == 1) {
            RouterKeyFilter keyValue = keyValueArr[0];
            return this.getDataSourceInfosFromOneKeyFilter(keyValue);
        }
        ArrayList<DataSourceInfo[]> metrix = new ArrayList<DataSourceInfo[]>(keyValueArr.length);
        for (int i = 0; i < keyValueArr.length; ++i) {
            metrix.add(this.getDataSourceInfosFromOneKeyFilter(keyValueArr[i]));
        }
        return InSectUtil.computeInsect(metrix);
    }

    private DataSourceInfo[] getDataSourceInfosFromOneKeyFilter(RouterKeyFilter keyValue) {
        DataSourceInfo[] algmResults;
        if (keyValue.getOperator() == RouterKeyFilter.Operator.EQUAL) {
            ITsAlgorithm.Result result = TsAlgmManager.getResult(this.dataSource, this.tableName, keyValue.getConstValue()[0]);
            algmResults = this.convertToOneDataSourceInfo(result);
        } else {
            algmResults = TsAlgmManager.getMultiResults(this.dataSource, this.tableName, keyValue);
        }
        return algmResults;
    }

    private DataSourceInfo[] convertToOneDataSourceInfo(ITsAlgorithm.Result result) {
        DataSourceInfo[] dsi = new DataSourceInfo[]{new DataSourceInfo()};
        dsi[0].setDsName(result.getDataSource());
        dsi[0].setDestTbs(new String[]{result.getTableName()});
        return dsi;
    }

    protected final List<RouterKeyFilter> getKeyFilterFromWhere(Expression where) {
        String colName = this.getTableCfg().getKeyField();
        List<RouterKeyFilter> list = VisitorExpressionManager.getKeyFilterList(where, colName, this.parameters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    protected final String getFinalSql(String finalTableName) {
        try {
            this.temporyChangeTableNameTo(finalTableName);
            String string = this.statement.toString();
            return string;
        }
        finally {
            this.temporyChangeTableNameTo(this.tableName);
        }
    }

    private RouterDataSourceConfig.TableConfig getTableCfg() {
        if (this.tableConfig != null) {
            return this.tableConfig;
        }
        RouterDataSourceConfig.TableConfig tableCfg = this.dataSource.getConfig().findTableConfig(this.tableName);
        if (tableCfg == null) {
            new TablesplitException("The table is configed as a splate table." + this.tableName);
        }
        this.tableConfig = tableCfg;
        return tableCfg;
    }

    protected RouterDataSourceConfig.TableConfig getTableCfg(RouterDataSource ds, String tableName) {
        RouterDataSourceConfig.TableConfig tableCfg = ds.getConfig().findTableConfig(tableName);
        if (tableCfg == null) {
            new TablesplitException("The table is configed as a splate table." + tableName);
        }
        return tableCfg;
    }

    public static void main(String[] args) {
        AbstractCommandHandler2 o = AbstractCommandHandler2.create(null, "select count(*),count(1) from t1,t2,t3 where a=b", null);
        System.out.println(o);
    }
}

