/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.conn.mulqry.rswrapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.jplugin.core.das.route.impl.CombinedSelectContext;
import net.jplugin.core.das.route.impl.conn.mulqry.rswrapper.GroupByMemoryOrderByWrapper;
import net.jplugin.core.das.route.impl.conn.mulqry.rswrapper.GroupByWrapper;
import net.jplugin.core.das.route.impl.conn.mulqry.rswrapper.WrapperController;
import net.jplugin.core.das.route.impl.util.SelectSqlKit;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;

public class GroupByWrapperController
implements WrapperController {
    private static final String OLD_ORDERBY = "OLD_ORDERBY";
    private static final String USING_GROUPBY = "USING_GROUPBY";
    private static final String GROUPBY_SQL_SELECTLIST = "GROUPBY_SQL_SELECTLIST";
    private static SelectItem ROW_COUNT_ITEM = GroupByWrapperController.makeRowCountItem();
    private static StringValue splitChar = new StringValue("#");

    @Override
    public boolean needWrap() {
        CombinedSelectContext combinedSqlContext = CombinedSelectContext.get();
        Boolean b = (Boolean)combinedSqlContext.getAttribute(USING_GROUPBY);
        return b != null && b != false;
    }

    private static SelectItem makeRowCountItem() {
        Function func = new Function();
        func.setName("COUNT");
        func.setAllColumns(true);
        SelectExpressionItem item = new SelectExpressionItem();
        item.setExpression((Expression)func);
        item.setAlias(new Alias("_GROUP_BY_AUTOADD_"));
        return item;
    }

    @Override
    public ResultSet wrap(ResultSet rs) throws SQLException {
        CombinedSelectContext combinedSqlContext = CombinedSelectContext.get();
        Boolean b = (Boolean)combinedSqlContext.getAttribute(USING_GROUPBY);
        if (b != null && b.booleanValue()) {
            try {
                List initialItems = (List)combinedSqlContext.getAttribute(GROUPBY_SQL_SELECTLIST);
                rs = new GroupByWrapper(rs, initialItems);
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage() + " " + CombinedSelectContext.get().getOriginalSql(), e);
            }
            List oldOrderBy = (List)combinedSqlContext.getAttribute(OLD_ORDERBY);
            if (oldOrderBy != null) {
                rs = new GroupByMemoryOrderByWrapper((GroupByWrapper)rs, oldOrderBy);
            }
        }
        return rs;
    }

    @Override
    public void handleContextInitial(CombinedSelectContext ctx) {
        SelectBody bd = ctx.getStatement().getSelectBody();
        PlainSelect inner = SelectSqlKit.getMostInnerSelect(bd, ctx.getOriginalSql());
        GroupByElement groupBy = inner.getGroupBy();
        List groupbylist = null;
        if (groupBy != null) {
            groupbylist = groupBy.getGroupByExpressions();
        }
        if (groupbylist != null && !groupbylist.isEmpty()) {
            ArrayList initialSelectItems = new ArrayList(inner.getSelectItems().size());
            initialSelectItems.addAll(inner.getSelectItems());
            ctx.setAttribute(GROUPBY_SQL_SELECTLIST, initialSelectItems);
            ctx.setAttribute(USING_GROUPBY, true);
            SelectExpressionItem itemToAdd = this.makeSelectItem(groupbylist);
            inner.getSelectItems().add(itemToAdd);
            inner.getSelectItems().add(ROW_COUNT_ITEM);
            List oldorderby = inner.getOrderByElements();
            if (oldorderby != null && !oldorderby.isEmpty()) {
                ctx.setAttribute(OLD_ORDERBY, oldorderby);
            }
            inner.setOrderByElements(this.makeNewOrderBy(groupbylist));
        }
    }

    private List<OrderByElement> makeNewOrderBy(List<Expression> groupbylist) {
        ArrayList<OrderByElement> result = new ArrayList<OrderByElement>();
        for (Expression o : groupbylist) {
            OrderByElement obe = new OrderByElement();
            obe.setExpression(o);
            result.add(obe);
        }
        return result;
    }

    private SelectExpressionItem makeSelectItem(List<Expression> groupbylist) {
        Function func = new Function();
        ExpressionList exps = new ExpressionList();
        ArrayList<Object> explist = new ArrayList<Object>();
        for (Expression groupitem : groupbylist) {
            explist.add(groupitem);
            explist.add(splitChar);
        }
        exps.setExpressions(explist);
        func.setParameters(exps);
        func.setName("concat");
        SelectExpressionItem item = new SelectExpressionItem();
        item.setExpression((Expression)func);
        item.setAlias(new Alias("_GROUP_BY_AUTOADD_"));
        return item;
    }
}

