/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.conn.mulqry.rswrapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.jplugin.core.das.route.impl.conn.mulqry.rswrapper.ExpressionAggregrator;
import net.jplugin.core.das.route.impl.util.BaseResultSetRow;
import net.sf.jsqlparser.statement.select.SelectItem;

public class GroupByWrapper
extends BaseResultSetRow {
    ResultSet inner;
    private int columnCount;
    long count = -1L;
    boolean beforeFirst = true;
    boolean afterLast = false;
    boolean currentIsLastRow = false;
    List<ExpressionAggregrator> aggregrateList;

    public GroupByWrapper(ResultSet l, List<SelectItem> initialItems) throws SQLException {
        super(l.getMetaData(), l.getMetaData().getColumnCount() - 2);
        this.columnCount = l.getMetaData().getColumnCount() - 2;
        this.inner = l;
        this.initExpressionAggrator(initialItems);
    }

    private void initExpressionAggrator(List<SelectItem> initialItems) {
        int size = initialItems.size();
        this.aggregrateList = new ArrayList<ExpressionAggregrator>(size);
        for (int i = 0; i < size; ++i) {
            this.aggregrateList.add(new ExpressionAggregrator(initialItems.get(i)));
        }
    }

    @Override
    public boolean next() throws SQLException {
        boolean b;
        this.clearCurrentRowValue();
        this.clearExpressionAggregateStatus();
        if (this.currentIsLastRow) {
            this.afterLast = true;
            return false;
        }
        if (this.beforeFirst && !(b = this.inner.next())) {
            return false;
        }
        this.beforeFirst = false;
        String currentGroupKey = this.inner.getString(this.columnCount + 1);
        this.fetchValue();
        while (this.inner.next()) {
            String temp = this.inner.getString(this.columnCount + 1);
            if (this.equal(temp, currentGroupKey)) {
                this.fetchValue();
                continue;
            }
            this.initCurrentRowData();
            return true;
        }
        this.currentIsLastRow = true;
        this.initCurrentRowData();
        return true;
    }

    private void initCurrentRowData() throws SQLException {
        int size = this.aggregrateList.size();
        List<Object> coldata = super.getBaseResultSetRowData();
        for (int i = 0; i < size; ++i) {
            Object result = this.aggregrateList.get(i).getResult(super.getMeta().getColumnType(i + 1));
            coldata.set(i, result);
        }
    }

    private void clearExpressionAggregateStatus() {
        int size = this.aggregrateList.size();
        for (int i = 0; i < size; ++i) {
            this.aggregrateList.get(i).resetState();
        }
    }

    private boolean equal(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private void fetchValue() throws SQLException {
        int valueCnt = this.inner.getInt(this.columnCount + 2);
        for (int i = 0; i < this.columnCount; ++i) {
            Object v = this.inner.getObject(i + 1);
            this.aggregrateList.get(i).aggrateItem(v, valueCnt, super.getMeta().getColumnType(i + 1));
        }
    }

    @Override
    public void close() throws SQLException {
        this.inner.close();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.inner.getCursorName();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.inner.getStatement();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new TruncedMetaDataAdaptor(this.inner.getMetaData(), this.columnCount);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.beforeFirst;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.afterLast;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.inner.isClosed();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.inner.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.inner.isWrapperFor(iface);
    }

    static class TruncedMetaDataAdaptor
    implements ResultSetMetaData {
        private ResultSetMetaData meta;
        private int colCount;

        public TruncedMetaDataAdaptor(ResultSetMetaData metaData, int acolCount) {
            this.meta = metaData;
            this.colCount = acolCount;
        }

        @Override
        public int getColumnCount() throws SQLException {
            return this.colCount;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.meta.unwrap(iface);
        }

        @Override
        public boolean isAutoIncrement(int column) throws SQLException {
            return this.meta.isAutoIncrement(column);
        }

        @Override
        public boolean isCaseSensitive(int column) throws SQLException {
            return this.meta.isCaseSensitive(column);
        }

        @Override
        public boolean isSearchable(int column) throws SQLException {
            return this.meta.isSearchable(column);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.meta.isWrapperFor(iface);
        }

        @Override
        public boolean isCurrency(int column) throws SQLException {
            return this.meta.isCurrency(column);
        }

        @Override
        public int isNullable(int column) throws SQLException {
            return this.meta.isNullable(column);
        }

        @Override
        public boolean isSigned(int column) throws SQLException {
            return this.meta.isSigned(column);
        }

        @Override
        public int getColumnDisplaySize(int column) throws SQLException {
            return this.meta.getColumnDisplaySize(column);
        }

        @Override
        public String getColumnLabel(int column) throws SQLException {
            return this.meta.getColumnLabel(column);
        }

        @Override
        public String getColumnName(int column) throws SQLException {
            return this.meta.getColumnName(column);
        }

        @Override
        public String getSchemaName(int column) throws SQLException {
            return this.meta.getSchemaName(column);
        }

        @Override
        public int getPrecision(int column) throws SQLException {
            return this.meta.getPrecision(column);
        }

        @Override
        public int getScale(int column) throws SQLException {
            return this.meta.getScale(column);
        }

        @Override
        public String getTableName(int column) throws SQLException {
            return this.meta.getTableName(column);
        }

        @Override
        public String getCatalogName(int column) throws SQLException {
            return this.meta.getCatalogName(column);
        }

        @Override
        public int getColumnType(int column) throws SQLException {
            return this.meta.getColumnType(column);
        }

        @Override
        public String getColumnTypeName(int column) throws SQLException {
            return this.meta.getColumnTypeName(column);
        }

        @Override
        public boolean isReadOnly(int column) throws SQLException {
            return this.meta.isReadOnly(column);
        }

        @Override
        public boolean isWritable(int column) throws SQLException {
            return this.meta.isWritable(column);
        }

        @Override
        public boolean isDefinitelyWritable(int column) throws SQLException {
            return this.meta.isDefinitelyWritable(column);
        }

        @Override
        public String getColumnClassName(int column) throws SQLException {
            return this.meta.getColumnClassName(column);
        }
    }
}

