/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.conn.mulqry.rswrapper;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.jplugin.common.kits.Comparor;
import net.jplugin.common.kits.SortUtil;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.das.route.impl.CombinedSelectContext;
import net.jplugin.core.das.route.impl.conn.mulqry.rswrapper.GroupByWrapper;
import net.jplugin.core.das.route.impl.util.BaseResultSetRow;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.OrderByElement;

public class GroupByMemoryOrderByWrapper
extends BaseResultSetRow {
    GroupByWrapper inner;
    List<List<Object>> dataGrid;
    private List<OrderByInfo> initialOrderBy;
    RowComparor rowComparor = new RowComparor();
    int currentRowIndex = -1;
    boolean beforeFirst = true;
    boolean afterLast = false;
    private ResultSetMetaData resultSetMetaData;
    private boolean isClosed;
    static int rowLimit;

    public GroupByMemoryOrderByWrapper(GroupByWrapper rs, List<OrderByElement> oldOrderBy) throws SQLException {
        super(rs.getBaseResultSetRowMeta());
        this.inner = rs;
        this.initialOrderBy = this.parseOrderBy(oldOrderBy);
        this.resultSetMetaData = rs.getMetaData();
        this.initData();
    }

    private List<OrderByInfo> parseOrderBy(List<OrderByElement> list) throws SQLException {
        ArrayList<OrderByInfo> temp = new ArrayList<OrderByInfo>(list.size());
        for (OrderByElement obe : list) {
            Expression exp = obe.getExpression();
            if (!(exp instanceof Column)) {
                throw new SQLException("the order by must be a column. " + exp.toString() + " sql=" + CombinedSelectContext.get().getOriginalSql());
            }
            OrderByInfo o = new OrderByInfo();
            o.fieldName = ((Column)exp).getColumnName();
            o.isDesc = !obe.isAsc();
            int idx = super.getMeta().getColumnIndex(o.fieldName);
            if (idx <= 0) {
                throw new SQLException("Can't find the order by column in sql. " + o.fieldName + "  sql=" + CombinedSelectContext.get().getOriginalSql());
            }
            o.columnIndex = idx;
            temp.add(o);
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRowLimit() {
        if (rowLimit > 0) {
            return rowLimit;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (rowLimit <= 0) {
                rowLimit = ConfigFactory.getIntConfig("platform.route-sql-memory-order-limit", 2000);
            }
            return rowLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initData() {
        try {
            this.dataGrid = new ArrayList<List<Object>>();
            try {
                int rowCnt = 0;
                while (this.inner.next()) {
                    if (++rowCnt > this.getRowLimit()) {
                        throw new RuntimeException("platform.route-sql-memory-order-limit overflow." + CombinedSelectContext.get().getFinalSql());
                    }
                    List<Object> row = this.inner.getBaseResultSetRowData();
                    ArrayList<Object> temp = new ArrayList<Object>(row.size());
                    temp.addAll(row);
                    this.dataGrid.add(temp);
                }
            }
            finally {
                try {
                    this.inner.close();
                }
                catch (Exception rowCnt) {}
            }
            SortUtil.sort(this.dataGrid, (Comparor)this.rowComparor);
        }
        catch (SQLException e) {
            throw new RuntimeException(CombinedSelectContext.get().getFinalSql(), e);
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.afterLast) {
            return false;
        }
        this.clearRowData();
        this.beforeFirst = false;
        ++this.currentRowIndex;
        if (this.currentRowIndex >= this.dataGrid.size()) {
            this.afterLast = true;
            return false;
        }
        this.initRowData(this.currentRowIndex);
        return true;
    }

    private void initRowData(int idx) throws SQLException {
        super.setData(this.dataGrid.get(idx));
    }

    private void clearRowData() {
        super.clearCurrentRowValue();
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        if (this.dataGrid != null) {
            this.dataGrid.clear();
        }
        this.dataGrid = null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSetMetaData;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.afterLast;
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLException("not support");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    class RowComparor
    implements Comparor {
        RowComparor() {
        }

        @Override
        public boolean isGreaterThen(Object o1, Object o2) {
            List list1 = (List)o1;
            List list2 = (List)o2;
            for (OrderByInfo obi : GroupByMemoryOrderByWrapper.this.initialOrderBy) {
                Object v1 = list1.get(obi.columnIndex - 1);
                Object v2 = list2.get(obi.columnIndex - 1);
                if (v2 == null) {
                    return false;
                }
                if (v1 == null) {
                    return true;
                }
                int result = ((Comparable)v1).compareTo(v2);
                if (result > 0) {
                    return !obi.isDesc;
                }
                if (result >= 0) continue;
                return obi.isDesc;
            }
            return false;
        }
    }

    static class OrderByInfo {
        public int columnIndex;
        String fieldName;
        boolean isDesc;

        OrderByInfo() {
        }
    }
}

