/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.conn.mulqry.rswrapper;

import java.sql.SQLException;
import net.jplugin.core.das.route.api.AggFunctionEvalueContext;
import net.jplugin.core.das.route.api.IAggregationFunctionHandler;
import net.jplugin.core.das.route.function.FunctionHandlerManager;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;

public class ExpressionAggregrator {
    private SelectExpressionItem selectItem;
    private AggFunctionEvalueContext ctx = new AggFunctionEvalueContext();
    private IAggregationFunctionHandler aggFunction;

    public ExpressionAggregrator(SelectItem si) {
        if (si instanceof SelectExpressionItem) {
            this.selectItem = (SelectExpressionItem)si;
            Expression exp = this.selectItem.getExpression();
            if (exp instanceof Function) {
                String functionName = ((Function)exp).getName().toUpperCase();
                IAggregationFunctionHandler fun = FunctionHandlerManager.INSTANCE.getAggFunctionHandler(functionName.toUpperCase());
                if (fun != null) {
                    this.aggFunction = fun;
                } else {
                    new RuntimeException("Unknown support function: " + functionName);
                }
            }
        } else {
            throw new RuntimeException("select item must be a Expression. " + si.toString());
        }
    }

    public void aggrateItem(Object v, int rowCntForCurentValue, int coltype) throws SQLException {
        if (this.aggFunction != null) {
            this.aggFunction.aggrate(this.ctx, v, rowCntForCurentValue, coltype);
        } else if (!this.ctx.containAttribute("FIRST_ROW")) {
            this.ctx.setAttribute("FIRST_ROW", v);
        }
    }

    public Object getResult(int sqlType) throws SQLException {
        if (this.aggFunction != null) {
            return this.aggFunction.getResult(this.ctx, sqlType);
        }
        if (!this.ctx.containAttribute("FIRST_ROW")) {
            throw new RuntimeException("Can't find the first row attribute.");
        }
        return this.ctx.getAttribute("FIRST_ROW");
    }

    public void resetState() {
        this.ctx.clear();
    }
}

