/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.conn.mulqry.rswrapper;

import java.sql.ResultSet;
import java.util.List;
import net.jplugin.core.das.route.impl.CombinedSelectContext;
import net.jplugin.core.das.route.impl.conn.mulqry.rswrapper.CountStarWrapper;
import net.jplugin.core.das.route.impl.conn.mulqry.rswrapper.WrapperController;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;

public class CountStarWrapperController
implements WrapperController {
    private static final String COUNT_STAR = "COUNT_STAR";

    @Override
    public boolean needWrap() {
        CombinedSelectContext ctx = CombinedSelectContext.get();
        Object flag = ctx.getAttribute(COUNT_STAR);
        return flag != null && (Boolean)flag != false;
    }

    @Override
    public ResultSet wrap(ResultSet rs) {
        return new CountStarWrapper(rs);
    }

    @Override
    public void handleContextInitial(CombinedSelectContext ctx) {
        ctx.setAttribute(COUNT_STAR, this.isCountStar((Statement)ctx.getStatement()));
    }

    private boolean isCountStar(Statement statement) {
        SelectBody body = ((Select)statement).getSelectBody();
        List items = ((PlainSelect)body).getSelectItems();
        if (items.size() != 1) {
            return false;
        }
        SelectItem onlyItem = (SelectItem)items.get(0);
        if (!(onlyItem instanceof SelectExpressionItem)) {
            return false;
        }
        Expression expression = ((SelectExpressionItem)onlyItem).getExpression();
        if (!(expression instanceof Function)) {
            return false;
        }
        Function function = (Function)expression;
        if (!"count".equalsIgnoreCase(function.getName())) {
            return false;
        }
        ExpressionList functionParams = function.getParameters();
        if (functionParams == null && function.isAllColumns()) {
            return true;
        }
        List expressions = functionParams.getExpressions();
        if (expressions == null) {
            return false;
        }
        if (expressions.size() == 0 && function.isAllColumns()) {
            return true;
        }
        if (expressions.size() > 1) {
            return false;
        }
        Expression functionParam = (Expression)expressions.get(0);
        return functionParam instanceof LongValue;
    }
}

