/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.conn.mulqry.aggfunc;

import java.math.BigDecimal;
import java.sql.SQLException;
import net.jplugin.core.das.route.api.AggFunctionEvalueContext;
import net.jplugin.core.das.route.impl.conn.mulqry.aggfunc.BaseMathAggFunctionHandler;

public class SumAggFunction
extends BaseMathAggFunctionHandler {
    static final String SUM_VALUE = "SUM";

    @Override
    public Object getResult(AggFunctionEvalueContext ctx, int sqlType) throws SQLException {
        return ctx.getAttribute(SUM_VALUE);
    }

    @Override
    void aggrateValue(AggFunctionEvalueContext ctx, Class javaType, Object currentRowValue, int rowCount) throws SQLException {
        Object currentValue = currentRowValue;
        Object sumValue = ctx.getAttribute(SUM_VALUE);
        sumValue = sumValue == null ? currentValue : this.add(javaType, sumValue, currentValue);
        ctx.setAttribute(SUM_VALUE, sumValue);
    }

    private Object add(Class javaType, Object a, Object b) throws SQLException {
        if (javaType == Integer.class || javaType == Integer.TYPE) {
            return (Integer)a + (Integer)b;
        }
        if (javaType == Short.class || javaType == Short.TYPE) {
            return (Short)a + (Short)b;
        }
        if (javaType == Byte.class || javaType == Short.TYPE) {
            return (Byte)a + (Byte)b;
        }
        if (javaType == Float.class || javaType == Float.TYPE) {
            return Float.valueOf(((Float)a).floatValue() + ((Float)b).floatValue());
        }
        if (javaType == Double.class || javaType == Double.TYPE) {
            return (Double)a + (Double)b;
        }
        if (javaType == BigDecimal.class) {
            return ((BigDecimal)a).add((BigDecimal)b);
        }
        throw new SQLException("unsupport type to sum:" + javaType);
    }
}

