/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.conn.mulqry.aggfunc;

import java.math.BigDecimal;
import java.sql.SQLException;
import net.jplugin.core.das.route.api.AggFunctionEvalueContext;
import net.jplugin.core.das.route.impl.conn.mulqry.aggfunc.BaseMathAggFunctionHandler;
import net.jplugin.core.das.route.impl.util.SqlTypeKit;

public class AvgAggFunction
extends BaseMathAggFunctionHandler {
    static final String TOTAL_VALUE = "TOTAL_VALUE";
    static final String TOTAL_CNT = "TOTAL_CNT";

    @Override
    public Object getResult(AggFunctionEvalueContext ctx, int sqlType) throws SQLException {
        BigDecimal totalValue = (BigDecimal)ctx.getAttribute(TOTAL_VALUE);
        if (totalValue == null) {
            return null;
        }
        Long totalCnt = (Long)ctx.getAttribute(TOTAL_CNT);
        BigDecimal result = totalValue.divide(new BigDecimal(totalCnt));
        return result;
    }

    @Override
    void aggrateValue(AggFunctionEvalueContext ctx, Class javaType, Object currentRowValue, int rowCount) throws SQLException {
        BigDecimal currentValue = SqlTypeKit.get(currentRowValue, BigDecimal.class).multiply(new BigDecimal(rowCount));
        BigDecimal oldValue = (BigDecimal)ctx.getAttribute(TOTAL_VALUE);
        Long oldCount = (Long)ctx.getAttribute(TOTAL_CNT);
        if (oldValue == null) {
            oldValue = currentValue;
            oldCount = rowCount;
        } else {
            oldValue = oldValue.add(currentValue);
            oldCount = oldCount + (long)rowCount;
        }
        ctx.setAttribute(TOTAL_VALUE, oldValue);
        ctx.setAttribute(TOTAL_CNT, oldCount);
    }
}

