/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.conn.mulqry;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.jplugin.core.das.route.impl.CombinedSelectContext;
import net.jplugin.core.das.route.impl.conn.mulqry.CompareKit;

public class ResultSetOrderByTool {
    ColumnMeta[] columnMetas;
    PriorityQueue<OrderComparor> comparorQueue;
    static HashMap<Integer, OrderColumnType> typeMapping = new HashMap();

    public ResultSetOrderByTool(List<String> orderParam, ResultSet aResultSet) {
        if (orderParam != null && orderParam.size() > 0) {
            try {
                this.initColumnMetas(orderParam, aResultSet);
            }
            catch (SQLException e) {
                throw new TablesplitException(e.getMessage(), e);
            }
        }
        this.comparorQueue = orderParam != null && orderParam.size() > 0 ? new PriorityQueue<OrderComparor>(new Comparator<OrderComparor>(){

            @Override
            public int compare(OrderComparor o1, OrderComparor o2) {
                return this.doCompare(o1.getComparorValue(), o2.getComparorValue(), ResultSetOrderByTool.this.columnMetas);
            }

            private int doCompare(Object[] v1, Object[] v2, ColumnMeta[] m) {
                for (int i = 0; i < m.length; ++i) {
                    Comparable o1 = (Comparable)v1[i];
                    Comparable o2 = (Comparable)v2[i];
                    ColumnMeta cm = m[i];
                    int result = CompareKit.compareSupportNull(o1, o2);
                    if (result != 0 && cm.getDirection() == Direction.DESC) {
                        result = -result;
                    }
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        }) : new PriorityQueue<OrderComparor>(new Comparator<OrderComparor>(){

            @Override
            public int compare(OrderComparor o1, OrderComparor o2) {
                return o1.rsIndex - o2.rsIndex;
            }
        });
    }

    private void initColumnMetas(List<String> orderParam, ResultSet aResultSet) throws SQLException {
        int cnt = 0;
        for (String s : orderParam) {
            if (!",".equals(s)) continue;
            ++cnt;
        }
        this.columnMetas = new ColumnMeta[cnt + 1];
        ResultSetMetaData rsMeta = aResultSet.getMetaData();
        int metaIndex = 0;
        for (int pos = 0; pos < orderParam.size(); pos += 2) {
            String first = orderParam.get(pos);
            if (",".equals(first)) {
                throw new TablesplitException(" [,] is not expected here. order params=" + this.toString(orderParam) + "  " + CombinedSelectContext.get().getFinalSql());
            }
            String colName = first;
            String colDirection = null;
            if (pos < orderParam.size() - 1 && !",".equals(orderParam.get(pos + 1))) {
                colDirection = orderParam.get(++pos);
            }
            ColumnMeta cm = new ColumnMeta();
            cm.setColumnName(colName);
            cm.setDirection("desc".equalsIgnoreCase(colDirection) ? Direction.DESC : Direction.ASC);
            int colIndex = this.getColumnIndex(cm.getColumnName(), rsMeta);
            if (colIndex == -1) {
                throw new TablesplitException("The order by column [" + cm.getColumnName() + "] can't be found in the resultSet." + CombinedSelectContext.get().getFinalSql());
            }
            cm.setColumnIndex(colIndex);
            OrderColumnType colType = this.getColunType(rsMeta, colIndex);
            if (colType == null) {
                throw new TablesplitException("The order by column [" + cm.getColumnName() + "] type not support! " + CombinedSelectContext.get().getFinalSql());
            }
            cm.setColumnType(colType);
            this.columnMetas[metaIndex++] = cm;
        }
    }

    private String toString(List<String> list) {
        if (list == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            sb.append(" " + s);
        }
        return sb.toString();
    }

    private OrderColumnType getColunType(ResultSetMetaData rsMeta, int index) throws SQLException {
        int sqlType = rsMeta.getColumnType(index);
        return typeMapping.get(sqlType);
    }

    private int getColumnIndex(String columnName, ResultSetMetaData rsMeta) throws SQLException {
        int count = rsMeta.getColumnCount();
        columnName = columnName.toUpperCase();
        int index = -1;
        for (int i = 1; i <= count; ++i) {
            int columnNameLen;
            int nameLen;
            String name = rsMeta.getColumnName(i).toUpperCase();
            if (!name.endsWith(columnName) || (nameLen = name.length()) != (columnNameLen = columnName.length()) && name.charAt(nameLen - columnNameLen - 1) != '.') continue;
            index = i;
            break;
        }
        return index;
    }

    public OrderComparor pollFirst() {
        return this.comparorQueue.poll();
    }

    public void refreshAndAdd(OrderComparor oc, ResultSet rs) {
        try {
            this.update(oc, rs);
            this.comparorQueue.add(oc);
        }
        catch (SQLException s) {
            throw new TablesplitException(s.getMessage(), s);
        }
    }

    private void update(OrderComparor oc, ResultSet rs) throws SQLException {
        if (this.columnMetas == null || this.columnMetas.length == 0) {
            return;
        }
        Object[] values = new Object[this.columnMetas.length];
        for (int i = 0; i < this.columnMetas.length; ++i) {
            Object value;
            ColumnMeta meta = this.columnMetas[i];
            int colIndex = meta.getColumnIndex();
            switch (meta.getColumnType()) {
                case STRING: {
                    value = rs.getString(colIndex);
                    break;
                }
                case BIGDECIMAL: {
                    value = rs.getBigDecimal(colIndex);
                    break;
                }
                case BIGINTEGER: {
                    value = rs.getLong(colIndex);
                    break;
                }
                case SQLDATE: {
                    value = rs.getDate(colIndex);
                    break;
                }
                case SQLTIME: {
                    value = rs.getTime(colIndex);
                    break;
                }
                case SQLTIMESTAMP: {
                    value = rs.getTimestamp(colIndex);
                    break;
                }
                default: {
                    throw new RuntimeException("error type:" + (Object)((Object)meta.getColumnType()));
                }
            }
            values[i] = value;
            oc.setComparorValue(values);
        }
    }

    static {
        typeMapping.put(-6, OrderColumnType.BIGINTEGER);
        typeMapping.put(5, OrderColumnType.BIGINTEGER);
        typeMapping.put(4, OrderColumnType.BIGINTEGER);
        typeMapping.put(-5, OrderColumnType.BIGINTEGER);
        typeMapping.put(6, OrderColumnType.BIGDECIMAL);
        typeMapping.put(7, OrderColumnType.BIGDECIMAL);
        typeMapping.put(8, OrderColumnType.BIGDECIMAL);
        typeMapping.put(2, OrderColumnType.BIGDECIMAL);
        typeMapping.put(3, OrderColumnType.BIGDECIMAL);
        typeMapping.put(1, OrderColumnType.STRING);
        typeMapping.put(12, OrderColumnType.STRING);
        typeMapping.put(-1, OrderColumnType.STRING);
        typeMapping.put(91, OrderColumnType.SQLDATE);
        typeMapping.put(92, OrderColumnType.SQLTIME);
        typeMapping.put(93, OrderColumnType.SQLTIMESTAMP);
    }

    static class OrderComparor {
        int rsIndex;
        Object[] comparorValue;

        OrderComparor() {
        }

        public int getRsIndex() {
            return this.rsIndex;
        }

        public void setRsIndex(int rsIndex) {
            this.rsIndex = rsIndex;
        }

        public Object[] getComparorValue() {
            return this.comparorValue;
        }

        public void setComparorValue(Object[] comparorValue) {
            this.comparorValue = comparorValue;
        }
    }

    static class ColumnMeta {
        String columnName;
        Direction direction;
        private OrderColumnType columnType;
        private int columnIndex;

        ColumnMeta() {
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public OrderColumnType getColumnType() {
            return this.columnType;
        }

        public void setColumnType(OrderColumnType columnType) {
            this.columnType = columnType;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }
    }

    static enum Direction {
        ASC,
        DESC;

    }

    static enum OrderColumnType {
        STRING,
        BIGINTEGER,
        BIGDECIMAL,
        SQLDATE,
        SQLTIME,
        SQLTIMESTAMP;

    }
}

