/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.conn.mulqry;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.das.api.DataSourceFactory;
import net.jplugin.core.das.dds.api.IConnectionSettable;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.jplugin.core.das.dds.impl.EmptyStatement;
import net.jplugin.core.das.route.api.DataSourceInfo;
import net.jplugin.core.das.route.impl.CombinedSelectContext;
import net.jplugin.core.das.route.impl.conn.mulqry.CombinedSqlParser;
import net.jplugin.core.das.route.impl.conn.mulqry.ResultSetList;
import net.jplugin.core.das.route.impl.conn.mulqry.rswrapper.WrapperManager;

public class CombinedStatement
extends EmptyStatement
implements IConnectionSettable {
    protected List<Statement> statementList = new ArrayList<Statement>();
    protected ResultSet theResultSet;
    protected CommandType commandType;
    protected CombinedSqlParser.ParseResult sqlParseResult;
    protected int updateCount = -1;
    protected CombinedSelectContext selectContext;
    private boolean closed;
    private Connection conn;

    @Override
    public final boolean execute(String sql) throws SQLException {
        this.parseAndComputeTypeAndMakeSelectContext(sql);
        if (CommandType.SELECT.equals((Object)this.commandType)) {
            this.executeQueryInner(sql);
            return true;
        }
        this.executeUpdateInner(sql);
        return false;
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        this.parseAndComputeTypeAndMakeSelectContext(sql);
        AssertKit.assertEqual((Object)this.commandType, (Object)CommandType.SELECT);
        return this.executeQueryInner(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.parseAndComputeTypeAndMakeSelectContext(sql);
        AssertKit.assertTrue(this.commandType != CommandType.SELECT);
        return this.executeUpdateInner(sql);
    }

    protected void parseAndComputeTypeAndMakeSelectContext(String sql) {
        this.sqlParseResult = CombinedSqlParser.parse(sql);
        this.commandType = this.computeCommandType(this.sqlParseResult.getSql());
        if (CommandType.SELECT.equals((Object)this.commandType)) {
            this.selectContext = CombinedSelectContext.makeContext(this.sqlParseResult);
        }
    }

    private CommandType computeCommandType(String sql) {
        CommandType ct;
        String temp = sql.trim().substring(0, 6).toUpperCase();
        if (temp.startsWith("SELECT")) {
            ct = CommandType.SELECT;
        } else if (temp.startsWith("UPDATE")) {
            ct = CommandType.UPDATE;
        } else if (temp.startsWith("DELETE")) {
            ct = CommandType.DELETE;
        } else if (temp.startsWith("INSERT")) {
            ct = CommandType.INSERT;
        } else {
            throw new TablesplitException("not supported command type:" + sql);
        }
        return ct;
    }

    private final ResultSet executeQueryInner(String sql) throws SQLException {
        if (this.closed) {
            throw new TablesplitException("can't call in a closed statement");
        }
        ResultSetList resutSet = this.genResultSetList();
        this.theResultSet = WrapperManager.INSTANCE.wrap(resutSet);
        return this.theResultSet;
    }

    private int executeUpdateInner(String sql) {
        if (this.closed) {
            throw new TablesplitException("can't call in a closed statement");
        }
        List<Integer> updateResultList = this.genUpdateResultList();
        int sum = 0;
        for (Integer item : updateResultList) {
            sum += item.intValue();
        }
        this.updateCount = sum;
        return sum;
    }

    private List<Integer> genUpdateResultList() {
        ArrayList<Integer> tempList = new ArrayList<Integer>();
        try {
            DataSourceInfo[] dataSourceInfos = this.sqlParseResult.getMeta().getDataSourceInfos();
            String sqlToExecute = this.sqlParseResult.getSql();
            for (DataSourceInfo dsi : dataSourceInfos) {
                Connection conn = DataSourceFactory.getDataSource(dsi.getDsName()).getConnection();
                for (String destTbName : dsi.getDestTbs()) {
                    Statement stmt = conn.createStatement();
                    this.statementList.add(stmt);
                    Integer updateResult = stmt.executeUpdate(StringKit.replaceStr(sqlToExecute, "__THE_TB_SPS_HDR__", destTbName));
                    tempList.add(updateResult);
                }
            }
            return tempList;
        }
        catch (Exception e) {
            throw new TablesplitException(e.getMessage() + " sql=" + this.sqlParseResult.getSql(), e);
        }
    }

    private ResultSetList genResultSetList() throws SQLException {
        ArrayList<ResultSet> tempList = new ArrayList<ResultSet>();
        try {
            DataSourceInfo[] dataSourceInfos = this.selectContext.getDataSourceInfos();
            String sqlToExecute = this.selectContext.getFinalSql();
            for (DataSourceInfo dsi : dataSourceInfos) {
                Connection conn = DataSourceFactory.getDataSource(dsi.getDsName()).getConnection();
                for (String destTbName : dsi.getDestTbs()) {
                    Statement stmt = conn.createStatement();
                    this.statementList.add(stmt);
                    ResultSet resultSet = stmt.executeQuery(StringKit.replaceStr(sqlToExecute, "__THE_TB_SPS_HDR__", destTbName));
                    tempList.add(resultSet);
                }
            }
            ResultSetList ret = new ResultSetList(this, tempList, this.selectContext);
            return ret;
        }
        catch (Exception e) {
            for (ResultSet r : tempList) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TablesplitException(e.getMessage() + " sql=" + CombinedSelectContext.get().getFinalSql(), e);
        }
    }

    @Override
    public void close() throws SQLException {
        String message = "";
        int errNum = 0;
        for (Statement s : this.statementList) {
            try {
                s.close();
            }
            catch (Exception e) {
                ++errNum;
                message = message + " " + e.getMessage();
            }
        }
        this.closed = true;
        if (StringKit.isNotNull(errNum + " exception when close," + message)) {
            throw new TablesplitException(message);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.theResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new TablesplitException("not support");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new TablesplitException("update multi table is not supported");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new TablesplitException("update multi table is not supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new TablesplitException("update multi table is not supported");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new TablesplitException("not support");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new TablesplitException("not support");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new TablesplitException("not support");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new TablesplitException("not support");
    }

    public static enum CommandType {
        SELECT,
        UPDATE,
        INSERT,
        DELETE;

    }
}

