/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.conn.mulqry;

import net.jplugin.common.kits.JsonKit;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.jplugin.core.das.route.api.DataSourceInfo;

public class CombinedSqlParser {
    public static final String SPAN_DATASOURCE = "##SPAN##";

    public static ParseResult parse(String combinedSql) {
        int pos = combinedSql.indexOf("##");
        if (pos < 0) {
            throw new TablesplitException("not a combined sql:" + combinedSql);
        }
        String json = combinedSql.substring(0, pos);
        String sql = combinedSql.substring(pos + 2);
        ParseResult pr = new ParseResult();
        pr.sql = sql;
        pr.meta = JsonKit.json2Object(json, Meta.class);
        return pr;
    }

    public static String combine(String sql, Meta meta) {
        String json = JsonKit.object2Json(meta);
        return json + "##" + sql;
    }

    public static class OrderParam {
        String col;
        String direInfo;

        public String getCol() {
            return this.col;
        }

        public void setCol(String col) {
            this.col = col;
        }

        public String getDireInfo() {
            return this.direInfo;
        }

        public void setDireInfo(String direInfo) {
            this.direInfo = direInfo;
        }
    }

    public static class Meta {
        private String sourceTb;
        private DataSourceInfo[] dataSourceInfos;

        public String getSourceTb() {
            return this.sourceTb;
        }

        public void setSourceTb(String sourceTb) {
            this.sourceTb = sourceTb;
        }

        public DataSourceInfo[] getDataSourceInfos() {
            return this.dataSourceInfos;
        }

        public void setDataSourceInfos(DataSourceInfo[] dataSourceInfos) {
            this.dataSourceInfos = dataSourceInfos;
        }
    }

    public static class ParseResult {
        private String sql;
        private Meta meta;

        public String getSql() {
            return this.sql;
        }

        public Meta getMeta() {
            return this.meta;
        }
    }
}

