/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.conn;

import net.jplugin.core.das.route.api.DataSourceInfo;
import net.jplugin.core.das.route.api.RouterDataSourceConfig;
import net.jplugin.core.das.route.impl.conn.mulqry.CombinedSqlParser;
import net.sf.jsqlparser.statement.Statement;

public class SqlHandleResult {
    String sourceTable;
    String resultSql;
    DataSourceInfo[] dataSourceInfos;
    CommandType commandType;
    RouterDataSourceConfig.TableConfig tableConfig;
    Statement statement;

    public boolean _containDsTb(String ds, String tb) {
        for (DataSourceInfo dsi : this.dataSourceInfos) {
            if (!dsi.getDsName().equals(ds)) continue;
            for (String t : dsi.getDestTbs()) {
                if (!t.equals(tb)) continue;
                return true;
            }
        }
        return false;
    }

    public int _dsCount() {
        return this.dataSourceInfos.length;
    }

    public int _tbCount() {
        int cnt = 0;
        for (DataSourceInfo dsi : this.dataSourceInfos) {
            cnt += dsi.getDestTbs().length;
        }
        return cnt;
    }

    public int _dsTbCount(String ds) {
        for (DataSourceInfo dsi : this.dataSourceInfos) {
            if (!dsi.getDsName().equals(ds)) continue;
            return dsi.getDestTbs().length;
        }
        return 0;
    }

    public boolean singleTable() {
        return this.dataSourceInfos.length == 1 && this.dataSourceInfos[0].getDestTbs().length == 1;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    public String getResultSql() {
        return this.resultSql;
    }

    public void setResultSql(String resultSql) {
        this.resultSql = resultSql;
    }

    public DataSourceInfo[] getDataSourceInfos() {
        return this.dataSourceInfos;
    }

    public void setDataSourceInfos(DataSourceInfo[] dataSourceInfos) {
        this.dataSourceInfos = dataSourceInfos;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(CommandType commandType) {
        this.commandType = commandType;
    }

    public RouterDataSourceConfig.TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public void setTableConfig(RouterDataSourceConfig.TableConfig tableConfig) {
        this.tableConfig = tableConfig;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public String getEncodedSql() {
        CombinedSqlParser.Meta meta = new CombinedSqlParser.Meta();
        meta.setDataSourceInfos(this.dataSourceInfos);
        meta.setSourceTb(this.sourceTable);
        return CombinedSqlParser.combine(this.resultSql, meta);
    }

    public static enum CommandType {
        SELECT,
        UPDATE,
        INSERT,
        DELETE;

    }
}

