/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.autocreate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.tuple.Tuple3;
import net.jplugin.core.das.route.api.DataSourceInfo;
import net.jplugin.core.das.route.impl.TableAutoCreation;
import net.jplugin.core.das.route.impl.conn.SqlHandleResult;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubSelect;

public class TableExistsMaintainer {
    public static MaintainReturn lastMaintainResult;
    private static final String NO_RESULT_SELECT = "select 'a' from dual where 1=2";

    public static String makeCountResult(String alais) {
        return "select count(*) " + alais + " from dual where 1=2";
    }

    public static MaintainReturn maintainAndCheckNoneResult(SqlHandleResult shr) {
        boolean singleTableBefore = shr.singleTable();
        MaintainReturn result = TableExistsMaintainer.maintainAndCheckNoneResultInner(shr);
        if (PluginEnvirement.INSTANCE.isUnitTesting()) {
            lastMaintainResult = result;
        }
        if (!result.isSpecialCondition() && shr.singleTable() != singleTableBefore) {
            AssertKit.assertTrue(shr.getResultSql().indexOf("__THE_TB_SPS_HDR__") >= 0);
            shr.setResultSql(StringKit.replaceStr(shr.getResultSql(), "__THE_TB_SPS_HDR__", shr.getDataSourceInfos()[0].getDestTbs()[0]));
        }
        return result;
    }

    private static MaintainReturn maintainAndCheckNoneResultInner(SqlHandleResult shr) {
        if (shr.getCommandType() == SqlHandleResult.CommandType.INSERT) {
            TableExistsMaintainer.tryCreateTable(shr);
            return MaintainReturn.FALSE_NULL;
        }
        if (shr.getCommandType() == SqlHandleResult.CommandType.SELECT) {
            TableExistsMaintainer.tryRemoveTable(shr);
            if (shr.getDataSourceInfos().length == 0) {
                PlainSelect selectBody = (PlainSelect)((Select)shr.getStatement()).getSelectBody();
                Tuple3<Boolean, String, Boolean> checkResult = TableExistsMaintainer.checkCountStatement(selectBody);
                if (((Boolean)checkResult.first).booleanValue()) {
                    if (((Boolean)checkResult.third).booleanValue()) {
                        String sql = NO_RESULT_SELECT;
                        return MaintainReturn.with(false, sql);
                    }
                    String sql = TableExistsMaintainer.makeCountResult((String)checkResult.second);
                    return MaintainReturn.with(false, sql);
                }
                String sql = NO_RESULT_SELECT;
                return MaintainReturn.with(false, sql);
            }
            return MaintainReturn.FALSE_NULL;
        }
        if (shr.getCommandType() == SqlHandleResult.CommandType.UPDATE || shr.getCommandType() == SqlHandleResult.CommandType.DELETE) {
            TableExistsMaintainer.tryRemoveTable(shr);
            if (shr.getDataSourceInfos().length == 0) {
                return MaintainReturn.TRUE_NULL;
            }
            return MaintainReturn.FALSE_NULL;
        }
        throw new RuntimeException("not support yet");
    }

    private static Tuple3<Boolean, String, Boolean> checkCountStatement(PlainSelect ps) {
        List items = ps.getSelectItems();
        if (items.size() == 1) {
            SelectExpressionItem expressionItem;
            Expression exp;
            FromItem fromitem;
            SelectItem item = (SelectItem)items.get(0);
            if (item instanceof AllColumns && ps.getGroupBy() == null && (fromitem = ps.getFromItem()) instanceof SubSelect) {
                return TableExistsMaintainer.checkCountStatement((PlainSelect)((SubSelect)fromitem).getSelectBody());
            }
            if (item instanceof SelectExpressionItem && (exp = (expressionItem = (SelectExpressionItem)item).getExpression()) instanceof Function && "COUNT".equalsIgnoreCase(((Function)exp).getName())) {
                String countName = null;
                Alias alais = expressionItem.getAlias();
                if (alais != null) {
                    countName = expressionItem.getAlias().getName();
                }
                if (StringKit.isNull(countName)) {
                    countName = "`" + exp.toString() + "`";
                }
                Boolean isGroupby = ps.getGroupBy() != null;
                return Tuple3.with(true, countName, isGroupby);
            }
        }
        return Tuple3.with(false, null, null);
    }

    private static void tryCreateTable(SqlHandleResult shr) {
        for (DataSourceInfo ds : shr.getDataSourceInfos()) {
            for (String tb : ds.getDestTbs()) {
                TableAutoCreation.checkExistsAndCreate(shr.getTableConfig(), ds.getDsName(), tb, shr.getSourceTable());
            }
        }
    }

    private static void tryRemoveTable(SqlHandleResult shr) {
        HashSet<Object> notExistsTables = null;
        for (DataSourceInfo ds : shr.getDataSourceInfos()) {
            for (String tb : ds.getDestTbs()) {
                if (TableAutoCreation.checkExists(shr.getTableConfig(), ds.getDsName(), tb)) continue;
                if (notExistsTables == null) {
                    notExistsTables = new HashSet<Object>();
                }
                notExistsTables.add(TableExistsMaintainer.makeKey(ds.getDsName(), tb));
            }
        }
        if (notExistsTables != null && !notExistsTables.isEmpty()) {
            shr.setDataSourceInfos(TableExistsMaintainer.makeNewDsInfo(shr.getDataSourceInfos(), notExistsTables));
        }
    }

    private static DataSourceInfo[] makeNewDsInfo(DataSourceInfo[] dataSourceInfos, Set notExistsTables) {
        HashMap<String, ArrayList<String>> newInfo = new HashMap<String, ArrayList<String>>();
        for (DataSourceInfo ds : dataSourceInfos) {
            for (String tb : ds.getDestTbs()) {
                if (notExistsTables.contains(TableExistsMaintainer.makeKey(ds.getDsName(), tb))) continue;
                ArrayList<String> targetList = (ArrayList<String>)newInfo.get(ds.getDsName());
                if (targetList == null) {
                    targetList = new ArrayList<String>();
                    newInfo.put(ds.getDsName(), targetList);
                }
                targetList.add(tb);
            }
        }
        DataSourceInfo[] ret = new DataSourceInfo[newInfo.size()];
        int pos = 0;
        for (Map.Entry en : newInfo.entrySet()) {
            DataSourceInfo dsi = new DataSourceInfo();
            dsi.setDsName((String)en.getKey());
            dsi.setDestTbs(((List)en.getValue()).toArray(new String[((List)en.getValue()).size()]));
            ret[pos++] = dsi;
        }
        return ret;
    }

    private static Object makeKey(String dsName, String tb) {
        return dsName + "##" + tb;
    }

    public static class MaintainReturn {
        public static final MaintainReturn TRUE_NULL = MaintainReturn.with(true, null);
        public static final MaintainReturn FALSE_NULL = MaintainReturn.with(false, null);
        boolean returnZeroRowUpdateStatement;
        String targetSqlForDummy;

        public static MaintainReturn with(boolean b, String s) {
            MaintainReturn o = new MaintainReturn();
            o.returnZeroRowUpdateStatement = b;
            o.targetSqlForDummy = s;
            return o;
        }

        public boolean isSpecialCondition() {
            AssertKit.assertTrue(!this.returnZeroRowUpdateStatement || this.targetSqlForDummy == null);
            return this.returnZeroRowUpdateStatement || this.targetSqlForDummy != null;
        }

        public boolean isReturnZeroRowUpdateStatement() {
            return this.returnZeroRowUpdateStatement;
        }

        public void setReturnZeroRowUpdateStatement(boolean returnZeroRowUpdateStatement) {
            this.returnZeroRowUpdateStatement = returnZeroRowUpdateStatement;
        }

        public String getTargetSqlForDummy() {
            return this.targetSqlForDummy;
        }

        public void setTargetSqlForDummy(String targetSqlForDummy) {
            this.targetSqlForDummy = targetSqlForDummy;
        }
    }
}

