/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.algms;

import java.util.Hashtable;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.jplugin.core.das.route.api.DataSourceInfo;
import net.jplugin.core.das.route.api.ITsAlgorithm;
import net.jplugin.core.das.route.api.RouterDataSource;
import net.jplugin.core.das.route.api.RouterDataSourceConfig;
import net.jplugin.core.das.route.api.RouterKeyFilter;

public class WightHashAlgm
implements ITsAlgorithm {
    private Hashtable<String, int[][]> tableMetrixMapping = new Hashtable();

    public int getTableIndex(RouterDataSource ds, String tableBaseName, ITsAlgorithm.ValueType vt, Object key, int splits) {
        long hashCode;
        if (vt == ITsAlgorithm.ValueType.LONG) {
            hashCode = (Long)key;
        } else if (key instanceof String) {
            hashCode = key.toString().hashCode();
        } else {
            throw new RuntimeException("not support algm for key java type:" + key.getClass().getName() + " algm is: " + this.getClass().getName());
        }
        int mod = (int)(hashCode % (long)splits);
        return mod;
    }

    public String getTableName(RouterDataSource ds, String tableBaseName, int index) {
        return tableBaseName + "_" + (index + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[][] getTableMetrix(RouterDataSource dataSource, String tableBaseName) {
        String key = dataSource.hashCode() + "_" + tableBaseName;
        int[][] result = this.tableMetrixMapping.get(key);
        if (result == null) {
            WightHashAlgm wightHashAlgm = this;
            synchronized (wightHashAlgm) {
                result = this.tableMetrixMapping.get(key);
                if (result == null) {
                    result = this.computeMetrix(dataSource, tableBaseName);
                    this.tableMetrixMapping.put(key, result);
                }
            }
        }
        return result;
    }

    @Override
    public ITsAlgorithm.Result getResult(RouterDataSource ds, String tableBaseName, ITsAlgorithm.ValueType vt, Object key) {
        RouterDataSourceConfig.DataSourceConfig[] dscfg = ds.getConfig().getDataSourceConfig();
        RouterDataSourceConfig.TableConfig tbcfg = ds.getConfig().findTableConfig(tableBaseName);
        int splits = tbcfg.getSplits();
        if (splits == 0) {
            throw new TablesplitException("Splits value error ,must >0 ,for table:" + tableBaseName);
        }
        int mod = this.getTableIndex(ds, tableBaseName, vt, key, splits);
        int[][] dsBottomTop = this.getTableMetrix(ds, tableBaseName);
        int targetDsIndex = -1;
        for (int i = 0; i < dsBottomTop.length; ++i) {
            int[] o = dsBottomTop[i];
            if (o[0] > mod || o[1] < mod) continue;
            targetDsIndex = i;
        }
        ITsAlgorithm.Result r = ITsAlgorithm.Result.create();
        r.setDataSource(dscfg[targetDsIndex].getDataSrouceCfgName());
        r.setTableName(this.getTableName(ds, tableBaseName, mod));
        return r;
    }

    private int[][] computeMetrix(RouterDataSource dataSource, String tableBaseName) {
        RouterDataSourceConfig.DataSourceConfig[] ds = dataSource.getConfig().getDataSourceConfig();
        RouterDataSourceConfig.TableConfig tbcfg = dataSource.getConfig().findTableConfig(tableBaseName);
        int splits = tbcfg.getSplits();
        this.checkWightValid(ds);
        int[][] dsBottomTop = new int[ds.length][2];
        int pos = 0;
        for (int i = 0; i < ds.length - 1; ++i) {
            RouterDataSourceConfig.DataSourceConfig dsc = ds[i];
            int size = (int)Math.round((double)(dsc.getWeight() * splits) * 1.0 / 100.0);
            dsBottomTop[i][0] = pos;
            dsBottomTop[i][1] = pos + size - 1;
            pos += size;
        }
        dsBottomTop[ds.length - 1][0] = pos;
        dsBottomTop[ds.length - 1][1] = splits - 1;
        return dsBottomTop;
    }

    private void checkWightValid(RouterDataSourceConfig.DataSourceConfig[] ds) {
        int snum = 0;
        for (RouterDataSourceConfig.DataSourceConfig o : ds) {
            snum += o.getWeight();
        }
        if (snum != 100) {
            throw new TablesplitException("for weightHash algm, Sum of weights for all datasources ,must be 100. tableName");
        }
    }

    @Override
    public DataSourceInfo[] getMultiResults(RouterDataSource dataSource, String tableName, ITsAlgorithm.ValueType valueType, RouterKeyFilter kva) {
        throw new RuntimeException("not impl");
    }
}

