/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.algms;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import net.jplugin.common.kits.CalenderKit;
import net.jplugin.core.das.dds.api.RouterException;
import net.jplugin.core.das.dds.api.TablesplitException;
import net.jplugin.core.das.route.api.ITsAlgorithm;

public class TimeConverterKit {
    public static long convertToTimeLong(ITsAlgorithm.ValueType vt, Object key) {
        switch (vt) {
            case DATE: {
                java.sql.Date dt = (java.sql.Date)key;
                return dt.getTime();
            }
            case TIMESTAMP: {
                return ((Timestamp)key).getTime();
            }
            case STRING: {
                return TimeConverterKit.convertStringTimeToDate((String)key).getTime();
            }
            case LONG: {
                return (Long)key;
            }
        }
        throw new TablesplitException("DateAlgm don't support type:" + (Object)((Object)vt));
    }

    private static Date convertStringTimeToDate(String key) {
        String pattern;
        switch (key.length()) {
            case 4: {
                pattern = "yyyy";
                break;
            }
            case 6: {
                pattern = "yyyyMM";
                break;
            }
            case 8: {
                pattern = "yyyyMMdd";
                break;
            }
            case 14: {
                pattern = "yyyyMMddHHmmss";
                break;
            }
            default: {
                throw new RuntimeException("unsupport string time format:" + key);
            }
        }
        return CalenderKit.getTimeFromString(key, pattern);
    }

    public static LocalDateTime convetToLoalDate(ITsAlgorithm.ValueType vt, Object object) {
        switch (vt) {
            case DATE: {
                return CalenderKit.convertDate2LocalDateTime((Date)object);
            }
            case TIMESTAMP: {
                return CalenderKit.convertDate2LocalDateTime((Date)object);
            }
            case STRING: {
                return CalenderKit.convertDate2LocalDateTime(TimeConverterKit.convertStringTimeToDate((String)object));
            }
            case LONG: {
                return CalenderKit.convertDate2LocalDateTime(new Date((Long)object));
            }
        }
        throw new RouterException("unsupported type:" + object.getClass());
    }
}

