/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.algms;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jplugin.common.kits.CalenderKit;
import net.jplugin.core.das.dds.api.RouterException;
import net.jplugin.core.das.route.api.DataSourceInfo;
import net.jplugin.core.das.route.api.ITsAlgorithm;
import net.jplugin.core.das.route.api.RouterDataSource;
import net.jplugin.core.das.route.api.RouterKeyFilter;
import net.jplugin.core.das.route.impl.algms.TimeConverterKit;

public class TimeBasedSpanUtil {
    public static DataSourceInfo[] getResults(ITsAlgorithm algm, RouterDataSource dataSource, String tableName, ITsAlgorithm.ValueType valueType, RouterKeyFilter kva, ChronoUnit unit, int trackDays) {
        if (kva.getOperator() == RouterKeyFilter.Operator.ALL) {
            return TimeBasedSpanUtil.get(algm, dataSource, tableName, trackDays, unit);
        }
        if (kva.getOperator() == RouterKeyFilter.Operator.BETWEEN) {
            return TimeBasedSpanUtil.getForBetween(algm, dataSource, tableName, valueType, kva.getConstValue(), unit, trackDays);
        }
        if (kva.getOperator() == RouterKeyFilter.Operator.IN) {
            return TimeBasedSpanUtil.getForIn(algm, dataSource, tableName, valueType, kva.getConstValue(), unit);
        }
        throw new RouterException("got error kva operator:" + (Object)((Object)kva.getOperator()));
    }

    private static DataSourceInfo[] getForIn(ITsAlgorithm algm, RouterDataSource dataSource, String tableName, ITsAlgorithm.ValueType valueType, Object[] value, ChronoUnit unit) {
        LocalDateTime[] arr = new LocalDateTime[value.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = TimeConverterKit.convetToLoalDate(valueType, value[i]);
        }
        return TimeBasedSpanUtil.getFromTimeList(algm, dataSource, tableName, arr);
    }

    private static DataSourceInfo[] getForBetween(ITsAlgorithm algm, RouterDataSource dataSource, String tableName, ITsAlgorithm.ValueType valueType, Object[] value, ChronoUnit unit, int trackDays) {
        LocalDateTime left;
        LocalDateTime right;
        Object leftValue = value[0];
        Object rightValue = value[1];
        if (leftValue == null && rightValue == null) {
            throw new RouterException("range can't be null.");
        }
        if (leftValue == null) {
            right = TimeConverterKit.convetToLoalDate(valueType, rightValue);
            left = TimeBasedSpanUtil.minusUnits(right, unit, trackDays);
        } else if (rightValue == null) {
            left = TimeConverterKit.convetToLoalDate(valueType, leftValue);
            right = TimeBasedSpanUtil.minusUnits(left, unit, -trackDays);
        } else {
            left = TimeConverterKit.convetToLoalDate(valueType, leftValue);
            right = TimeConverterKit.convetToLoalDate(valueType, rightValue);
        }
        left = TimeBasedSpanUtil.truncate(left, unit);
        right = TimeBasedSpanUtil.truncate(right, unit);
        ArrayList<LocalDateTime> list = new ArrayList<LocalDateTime>();
        long leftEpoch = CalenderKit.convertLocalDateTime2Date(left).getTime();
        for (int i = 0; i < 10000; ++i) {
            LocalDateTime newDate = TimeBasedSpanUtil.minusUnits(right, unit, i);
            if (CalenderKit.convertLocalDateTime2Date(newDate).getTime() < leftEpoch) continue;
            list.add(newDate);
        }
        LocalDateTime[] arr = new LocalDateTime[list.size()];
        list.toArray(arr);
        return TimeBasedSpanUtil.getFromTimeList(algm, dataSource, tableName, arr);
    }

    private static LocalDateTime truncate(LocalDateTime ld, ChronoUnit unit) {
        if (unit == ChronoUnit.DAYS) {
            return ld.truncatedTo(ChronoUnit.DAYS);
        }
        if (unit == ChronoUnit.MONTHS) {
            return LocalDateTime.of(ld.getYear(), ld.getMonth(), 1, 0, 0);
        }
        if (unit == ChronoUnit.YEARS) {
            return LocalDateTime.of(ld.getYear(), 1, 1, 0, 0);
        }
        throw new RuntimeException("unsupport unit." + unit);
    }

    private static LocalDateTime minusUnits(LocalDateTime ld, ChronoUnit unit, int trackDays) {
        return ld.minus(trackDays, unit);
    }

    private static DataSourceInfo[] get(ITsAlgorithm algm, RouterDataSource dataSource, String tableName, int historyNum, ChronoUnit unit) {
        LocalDateTime[] arr = new LocalDateTime[historyNum];
        LocalDateTime date = LocalDateTime.now();
        for (int i = 0; i < historyNum; ++i) {
            LocalDateTime newDate;
            arr[i] = newDate = TimeBasedSpanUtil.minusUnits(date, unit, i);
        }
        return TimeBasedSpanUtil.getFromTimeList(algm, dataSource, tableName, arr);
    }

    private static DataSourceInfo[] getFromTimeList(ITsAlgorithm algm, RouterDataSource dataSource, String tableName, LocalDateTime[] arr) {
        HashMap<String, HashSet<String>> mapList = new HashMap<String, HashSet<String>>();
        for (int i = 0; i < arr.length; ++i) {
            LocalDateTime newDate = arr[i];
            ITsAlgorithm.Result r = algm.getResult(dataSource, tableName, ITsAlgorithm.ValueType.TIMESTAMP, Timestamp.valueOf(newDate));
            HashSet<String> list = (HashSet<String>)mapList.get(r.getDataSource());
            if (list == null) {
                list = new HashSet<String>();
                mapList.put(r.getDataSource(), list);
            }
            list.add(r.getTableName());
        }
        DataSourceInfo[] ret = new DataSourceInfo[mapList.size()];
        int index = 0;
        for (Map.Entry en : mapList.entrySet()) {
            DataSourceInfo dsi = new DataSourceInfo();
            dsi.setDsName((String)en.getKey());
            dsi.setDestTbs(((Set)en.getValue()).toArray(new String[((Set)en.getValue()).size()]));
            ret[index++] = dsi;
        }
        return ret;
    }
}

