/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.das.route.impl.algms;

import java.time.temporal.ChronoUnit;
import java.util.Date;
import net.jplugin.common.kits.CalenderKit;
import net.jplugin.core.das.route.api.DataSourceInfo;
import net.jplugin.core.das.route.api.ITsAlgorithm;
import net.jplugin.core.das.route.api.RouterDataSource;
import net.jplugin.core.das.route.api.RouterDataSourceConfig;
import net.jplugin.core.das.route.api.RouterKeyFilter;
import net.jplugin.core.das.route.impl.algms.TimeBasedSpanUtil;
import net.jplugin.core.das.route.impl.algms.TimeConverterKit;

public class MonthAlgm
implements ITsAlgorithm {
    int trackMonths = 6;

    protected void setTrackMonths(int m) {
        this.trackMonths = m;
    }

    @Override
    public ITsAlgorithm.Result getResult(RouterDataSource compondDataSource, String tableBaseName, ITsAlgorithm.ValueType vt, Object key) {
        long time = TimeConverterKit.convertToTimeLong(vt, key);
        Date javaDate = new Date(time);
        int monIndex = javaDate.getYear() * 12 + (javaDate.getMonth() - 1);
        RouterDataSourceConfig.DataSourceConfig[] dsConfig = compondDataSource.getConfig().getDataSourceConfig();
        int dsIndex = monIndex % dsConfig.length;
        ITsAlgorithm.Result r = ITsAlgorithm.Result.create();
        r.setDataSource(dsConfig[dsIndex].getDataSrouceCfgName());
        r.setTableName(this.getTableName(tableBaseName, time));
        return r;
    }

    private String getTableName(String tableBaseName, long time) {
        return tableBaseName + "_" + CalenderKit.getShortMonthString(time);
    }

    @Override
    public DataSourceInfo[] getMultiResults(RouterDataSource dataSource, String tableName, ITsAlgorithm.ValueType valueType, RouterKeyFilter kva) {
        return TimeBasedSpanUtil.getResults(this, dataSource, tableName, valueType, kva, ChronoUnit.MONTHS, this.trackMonths);
    }
}

